/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.tools.SimpleActionGroup;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolManager;
import com.intellij.tools.ToolsGroup;

public class ExternalToolsGroup
extends SimpleActionGroup {
    public void update(AnActionEvent event) {
        ToolsGroup[] groups;
        Presentation presentation = event.getPresentation();
        this.removeAll();
        String context = event.getPlace();
        Project project = (Project)event.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            presentation.setVisible(false);
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
        for (ToolsGroup group : groups = ToolManager.getInstance().getGroups()) {
            String groupName = group.getName();
            if (groupName != null && groupName.trim().length() > 0) {
                SimpleActionGroup subgroup = new SimpleActionGroup();
                subgroup.getTemplatePresentation().setText(groupName, false);
                subgroup.setPopup(true);
                ExternalToolsGroup.fillGroup(context, groupName, subgroup);
                if (subgroup.getChildrenCount() <= 0) continue;
                this.add((AnAction)subgroup);
                continue;
            }
            ExternalToolsGroup.fillGroup(context, null, this);
        }
        presentation.setVisible(this.getChildrenCount() > 0);
    }

    private static void fillGroup(String context, String groupName, SimpleActionGroup group) {
        Tool[] tools;
        for (Tool tool : tools = ToolManager.getInstance().getTools(groupName)) {
            if (!ExternalToolsGroup.isToolVisible(tool, context)) continue;
            ExternalToolsGroup.addToolToGroup(tool, group);
        }
    }

    private static void addToolToGroup(Tool tool, SimpleActionGroup group) {
        String id = tool.getActionId();
        AnAction action = ActionManager.getInstance().getAction(id);
        if (action == null) {
            action = new ToolAction(tool);
        }
        group.add(action);
    }

    private static boolean isToolVisible(Tool tool, String context) {
        if (!tool.isEnabled()) {
            return false;
        }
        if ("EditorPopup".equals(context)) {
            return tool.isShownInEditor();
        }
        if ("ProjectViewPopup".equals(context) || "CommanderPopup".equals(context) || "J2EEViewPopup".equals(context) || "TypeHierarchyViewPopup".equals(context) || "CallHierarchyViewPopup".equals(context) || "MethodHierarchyViewPopup".equals(context) || "FavoritesPopup".equals(context) || "ScopeViewPopup".equals(context) || "NavBar".equals(context)) {
            return tool.isShownInProjectViews();
        }
        if ("MainMenu".equals(context)) {
            return tool.isShownInMainMenu();
        }
        if ("UsageViewPopup".equals(context)) {
            return tool.isShownInSearchResultsPopup();
        }
        return false;
    }
}

