/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.tools.FilterDialog;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.ToolsBundle;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.CommandButtonGroup;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class OutputFiltersDialog
extends DialogWrapper {
    private final DefaultListModel myFiltersModel = new DefaultListModel();
    private final JList myFiltersList = new JList(this.myFiltersModel);
    private final JButton myAddButton = new JButton(ToolsBundle.message("tools.filters.add.button", new Object[0]));
    private final JButton myEditButton = new JButton(ToolsBundle.message("tools.filters.edit.button", new Object[0]));
    private final JButton myRemoveButton = new JButton(ToolsBundle.message("tools.filters.remove.button", new Object[0]));
    private final JButton myMoveUpButton = new JButton(ToolsBundle.message("tools.filters.move.up.button", new Object[0]));
    private final JButton myMoveDownButton = new JButton(ToolsBundle.message("tools.filters.move.down.button", new Object[0]));
    private final CommandButtonGroup myButtonGroup = new CommandButtonGroup(1);
    private boolean myModified = false;
    private FilterInfo[] myFilters;

    public OutputFiltersDialog(Component parent, FilterInfo[] filters) {
        super(parent, true);
        this.myFilters = filters;
        this.setTitle(ToolsBundle.message("tools.filters.title", new Object[0]));
        this.init();
        this.initGui();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.settings.ide.settings.external.tools.output.filters");
    }

    private void initGui() {
        this.myFiltersList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                FilterInfo info = (FilterInfo)value;
                this.append(info.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        });
        this.myButtonGroup.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        this.myButtonGroup.addButton((AbstractButton)this.myAddButton);
        this.myButtonGroup.addButton((AbstractButton)this.myEditButton);
        this.myButtonGroup.addButton((AbstractButton)this.myRemoveButton);
        this.myButtonGroup.addButton((AbstractButton)this.myMoveUpButton);
        this.myButtonGroup.addButton((AbstractButton)this.myMoveDownButton);
        this.myEditButton.setEnabled(false);
        this.myRemoveButton.setEnabled(false);
        this.myMoveUpButton.setEnabled(false);
        this.myMoveDownButton.setEnabled(false);
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.setName(OutputFiltersDialog.this.suggestFilterName());
                boolean wasCreated = FilterDialog.editFilter(filterInfo, OutputFiltersDialog.this.myAddButton, ToolsBundle.message("tools.filters.add.title", new Object[0]));
                if (wasCreated) {
                    OutputFiltersDialog.this.myFiltersModel.addElement(filterInfo);
                    OutputFiltersDialog.this.setModified(true);
                    OutputFiltersDialog.this.enableButtons();
                }
                OutputFiltersDialog.this.myFiltersList.requestFocus();
            }
        });
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = OutputFiltersDialog.this.myFiltersList.getSelectedIndex();
                FilterInfo filterInfo = (FilterInfo)OutputFiltersDialog.this.myFiltersModel.getElementAt(index);
                boolean wasEdited = FilterDialog.editFilter(filterInfo, OutputFiltersDialog.this.myEditButton, ToolsBundle.message("tools.filters.edit.title", new Object[0]));
                if (wasEdited) {
                    OutputFiltersDialog.this.setModified(true);
                    OutputFiltersDialog.this.enableButtons();
                }
                OutputFiltersDialog.this.myFiltersList.requestFocus();
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OutputFiltersDialog.this.myFiltersList.getSelectedIndex() >= 0) {
                    OutputFiltersDialog.this.myFiltersModel.removeElementAt(OutputFiltersDialog.this.myFiltersList.getSelectedIndex());
                    OutputFiltersDialog.this.setModified(true);
                }
                OutputFiltersDialog.this.enableButtons();
                OutputFiltersDialog.this.myFiltersList.requestFocus();
            }
        });
        this.myMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int movedCount = ListUtil.moveSelectedItemsUp((JList)OutputFiltersDialog.this.myFiltersList);
                if (movedCount > 0) {
                    OutputFiltersDialog.this.setModified(true);
                }
                OutputFiltersDialog.this.myFiltersList.requestFocus();
            }
        });
        this.myMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int movedCount = ListUtil.moveSelectedItemsDown((JList)OutputFiltersDialog.this.myFiltersList);
                if (movedCount > 0) {
                    OutputFiltersDialog.this.setModified(true);
                }
                OutputFiltersDialog.this.myFiltersList.requestFocus();
            }
        });
        this.myFiltersList.setSelectionMode(0);
        this.myFiltersList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                OutputFiltersDialog.this.enableButtons();
            }
        });
        ListScrollingUtil.ensureSelectionExists((JList)this.myFiltersList);
    }

    private String suggestFilterName() {
        String prefix = ToolsBundle.message("tools.filters.name.template", new Object[0]) + " ";
        int number = 1;
        for (int i = 0; i < this.myFiltersModel.getSize(); ++i) {
            FilterInfo wrapper = (FilterInfo)this.myFiltersModel.getElementAt(i);
            String name = wrapper.getName();
            if (!name.startsWith(prefix)) continue;
            try {
                int n = Integer.valueOf(name.substring(prefix.length()).trim());
                number = Math.max(number, n + 1);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return prefix + number;
    }

    protected void doOKAction() {
        if (this.myModified) {
            this.myFilters = new FilterInfo[this.myFiltersModel.getSize()];
            for (int i = 0; i < this.myFiltersModel.getSize(); ++i) {
                this.myFilters[i] = (FilterInfo)this.myFiltersModel.get(i);
            }
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        for (int i = 0; i < this.myFilters.length; ++i) {
            this.myFiltersModel.addElement(this.myFilters[i].createCopy());
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.myFiltersList), "Center");
        panel.add((Component)this.myButtonGroup, "East");
        panel.setPreferredSize(new Dimension(400, 200));
        return panel;
    }

    private void enableButtons() {
        int size = this.myFiltersModel.getSize();
        int index = this.myFiltersList.getSelectedIndex();
        this.myEditButton.setEnabled(size != 0 && index != -1);
        this.myRemoveButton.setEnabled(size != 0 & index != -1);
        this.myMoveUpButton.setEnabled(ListUtil.canMoveSelectedItemsUp((JList)this.myFiltersList));
        this.myMoveDownButton.setEnabled(ListUtil.canMoveSelectedItemsDown((JList)this.myFiltersList));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFiltersList;
    }

    private void setModified(boolean modified) {
        this.myModified = modified;
    }

    public FilterInfo[] getData() {
        return this.myFilters;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.tools.OutputFiltersDialog";
    }
}

