/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.unscramble.ThreadOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ThreadState {
    private final String myName;
    private final String myState;
    private String myStackTrace;
    private boolean myEmptyStackTrace;
    private String myJavaThreadState;
    private String myThreadStateDetail;
    private String myExtraState;
    private boolean isDaemon = false;
    private final Set<ThreadState> myThreadsWaitingForMyLock = new HashSet<ThreadState>();
    private final Set<ThreadState> myDeadlockedThreads = new HashSet<ThreadState>();
    @Nullable
    private ThreadOperation myOperation;

    public ThreadState(String name, String state) {
        this.myName = name;
        this.myState = state.trim();
    }

    public String getName() {
        return this.myName;
    }

    public String getState() {
        return this.myState;
    }

    public String getStackTrace() {
        return this.myStackTrace;
    }

    public void setStackTrace(String stackTrace, boolean isEmpty) {
        this.myStackTrace = stackTrace;
        this.myEmptyStackTrace = isEmpty;
    }

    public Collection<ThreadState> getAwaitingThreads() {
        return Collections.unmodifiableSet(this.myThreadsWaitingForMyLock);
    }

    public String toString() {
        return this.myName;
    }

    public void setJavaThreadState(String javaThreadState) {
        this.myJavaThreadState = javaThreadState;
    }

    public void setThreadStateDetail(@NonNls String threadStateDetail) {
        this.myThreadStateDetail = threadStateDetail;
    }

    public String getJavaThreadState() {
        return this.myJavaThreadState;
    }

    public String getThreadStateDetail() {
        if (this.myOperation != null) {
            return this.myOperation.toString();
        }
        return this.myThreadStateDetail;
    }

    public boolean isEmptyStackTrace() {
        return this.myEmptyStackTrace;
    }

    public String getExtraState() {
        return this.myExtraState;
    }

    public void setExtraState(String extraState) {
        this.myExtraState = extraState;
    }

    public boolean isSleeping() {
        return "sleeping".equals(this.getThreadStateDetail()) || ("parking".equals(this.getThreadStateDetail()) || "waiting on condition".equals(this.myState)) && this.isThreadPoolExecutor();
    }

    private boolean isThreadPoolExecutor() {
        return this.myStackTrace.contains("java.util.concurrent.ScheduledThreadPoolExecutor$DelayedWorkQueue.take") || this.myStackTrace.contains("java.util.concurrent.ThreadPoolExecutor.getTask");
    }

    public boolean isAwaitedBy(ThreadState thread) {
        return this.myThreadsWaitingForMyLock.contains(thread);
    }

    public void addWaitingThread(ThreadState thread) {
        this.myThreadsWaitingForMyLock.add(thread);
    }

    public boolean isDeadlocked() {
        return !this.myDeadlockedThreads.isEmpty();
    }

    public void addDeadlockedThread(ThreadState thread) {
        this.myDeadlockedThreads.add(thread);
    }

    @Nullable
    public ThreadOperation getOperation() {
        return this.myOperation;
    }

    public void setOperation(@Nullable ThreadOperation operation) {
        this.myOperation = operation;
    }

    public boolean isWaiting() {
        return "on object monitor".equals(this.myThreadStateDetail) || this.myState.startsWith("waiting") || "parking".equals(this.myThreadStateDetail) && !this.isSleeping();
    }

    public boolean isEDT() {
        String name = this.getName();
        return ThreadState.isEDT(name);
    }

    public static boolean isEDT(String name) {
        return name.startsWith("AWT-EventQueue");
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public void setDaemon(boolean daemon) {
        this.isDaemon = daemon;
    }
}

