/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.classpath;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryTableImplUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.util.OrderEntryCellAppearanceUtils;
import com.intellij.openapi.roots.ui.util.SimpleTextCellAppearance;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ReorderableListController;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.Icons;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.classpath.ChooseLibrariesDialog;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;

public class SimpleClasspathPanel
extends JPanel {
    private final JList myList = new JList();
    private final DefaultListModel myListModel = new DefaultListModel();
    private URLClassLoader myClassLoader;
    private final Disposable myDisposable;

    public SimpleClasspathPanel(List<SimpleClasspathElement> classpathElements, Disposable parentDisposable) {
        this.myDisposable = parentDisposable;
        for (Library library : SimpleClasspathPanel.getLibrariesList(classpathElements, parentDisposable)) {
            this.myListModel.addElement(library);
        }
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.myList.setSelectionMode(1);
        this.myList.setModel(this.myListModel);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        ReorderableListController controller = ReorderableListController.create((JList)this.myList, (DefaultActionGroup)actionGroup);
        controller.addAction((AnAction)new AddAction());
        controller.addRemoveAction(ProjectBundle.message((String)"module.remove.action", (Object[])new Object[0]));
        controller.addMoveUpAction();
        controller.addMoveDownAction();
        this.customizeToolbarActions(actionGroup);
        this.myList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof Library) {
                    Library library = (Library)value;
                    if (library.getName() != null && library.getUrls(OrderRootType.CLASSES).length == 0) {
                        SimpleTextCellAppearance.invalid((String)library.getName(), (Icon)Icons.LIBRARY_ICON).customize((SimpleColoredComponent)this);
                    } else {
                        OrderEntryCellAppearanceUtils.forLibrary((Library)library).customize((SimpleColoredComponent)this);
                    }
                }
            }
        });
        this.add((Component)ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", (ActionGroup)actionGroup, true).getComponent(), "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myList);
        this.add((Component)scrollPane, "Center");
        FontMetrics fontMetrics = this.myList.getFontMetrics(this.myList.getFont());
        scrollPane.setPreferredSize(new Dimension(0, fontMetrics.getHeight() * 12));
        this.myList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                SimpleClasspathPanel.this.listChanged(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
    }

    protected void customizeToolbarActions(DefaultActionGroup actionGroup) {
    }

    private void listChanged(ListDataEvent e) {
        this.myClassLoader = null;
        this.processClasspathChanged();
    }

    public void processClasspathChanged() {
    }

    public List<Library> getOrderedLibraries() {
        ArrayList<Library> result = new ArrayList<Library>();
        Enumeration enumeration = this.myListModel.elements();
        while (enumeration.hasMoreElements()) {
            result.add((Library)enumeration.nextElement());
        }
        return result;
    }

    public Set<VirtualFile> getVirtualFiles() {
        THashSet result = new THashSet();
        Enumeration enumeration = this.myListModel.elements();
        while (enumeration.hasMoreElements()) {
            Library library = (Library)enumeration.nextElement();
            result.addAll(Arrays.asList(library.getFiles(OrderRootType.CLASSES)));
        }
        return result;
    }

    public URLClassLoader getClasspathLoader(ClassLoader parent) {
        if (this.myClassLoader == null || this.myClassLoader.getParent() != parent) {
            ArrayList<URL> urlList = new ArrayList<URL>();
            for (Library library : this.getOrderedLibraries()) {
                for (VirtualFile virtualFile : library.getFiles(OrderRootType.CLASSES)) {
                    File file = new File(PathUtil.toPresentableUrl((String)virtualFile.getUrl()));
                    try {
                        urlList.add(file.toURL());
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
            }
            URL[] urls = urlList.toArray(new URL[urlList.size()]);
            this.myClassLoader = new URLClassLoader(urls, parent);
        }
        return this.myClassLoader;
    }

    public static void scrollSelectionToVisible(JList list) {
        ListSelectionModel selectionModel = list.getSelectionModel();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        if (maxSelectionIndex == -1) {
            return;
        }
        Rectangle cellRect = list.getCellBounds(minSelectionIndex, maxSelectionIndex);
        list.scrollRectToVisible(cellRect);
    }

    private static Collection<Library> ensureApplicationLevel(Library library, Set<VirtualFile> existingFiles, Disposable parentDisposable) {
        if (library.getTable() == null || !"application".equals(library.getTable().getTableLevel())) {
            ArrayList<Library> result = new ArrayList<Library>();
            for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                if (!existingFiles.add(file)) continue;
                Library newLibrary = LibraryTableImplUtil.createModuleLevelLibrary(null, null);
                Disposer.register((Disposable)parentDisposable, (Disposable)newLibrary);
                Library.ModifiableModel libModel = newLibrary.getModifiableModel();
                libModel.addRoot(file, OrderRootType.CLASSES);
                libModel.commit();
                result.add(newLibrary);
            }
            return result;
        }
        return Collections.singletonList(library);
    }

    private static List<Library> getLibrariesList(List<SimpleClasspathElement> classpathElements, Disposable disposable) {
        ArrayList<Library> result = new ArrayList<Library>();
        for (SimpleClasspathElement classpathElement : classpathElements) {
            Library library = classpathElement.getLibrary();
            if (library != null && library.getTable() != null) {
                result.add(library);
                continue;
            }
            Library newLibrary = LibraryTableImplUtil.createModuleLevelLibrary(null, null);
            Disposer.register((Disposable)disposable, (Disposable)newLibrary);
            Library.ModifiableModel libModel = newLibrary.getModifiableModel();
            String libName = classpathElement.getLibraryName();
            if (libName != null) {
                libModel.setName(libName);
            }
            List<String> fileUrls = classpathElement.getClassesRootUrls();
            for (String fileUrl : fileUrls) {
                libModel.addRoot(fileUrl, OrderRootType.CLASSES);
            }
            libModel.commit();
            result.add(newLibrary);
        }
        return result;
    }

    private static class ChooseJarDialog
    extends FileChooserDialogImpl {
        private VirtualFile[] myLastChosen;
        private final Disposable myParentDisposable;

        public ChooseJarDialog(Component parent, final Set<VirtualFile> existingFiles, Disposable disposable) {
            super(new FileChooserDescriptor(false, true, true, false, false, true){

                public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                    if (!super.isFileVisible(file, showHiddenFiles)) {
                        return false;
                    }
                    return file.isDirectory() || !existingFiles.contains(file);
                }
            }, parent);
            this.myParentDisposable = disposable;
        }

        public List<Library> getChosenElements() {
            if (this.myLastChosen == null) {
                return Collections.emptyList();
            }
            VirtualFile[] files = this.myLastChosen;
            if (files.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<Library> addedLibraries = new ArrayList<Library>(files.length);
            for (VirtualFile file : files) {
                Library library = LibraryTableImplUtil.createModuleLevelLibrary(null, null);
                Disposer.register((Disposable)this.myParentDisposable, (Disposable)library);
                Library.ModifiableModel libModel = library.getModifiableModel();
                libModel.addRoot(file, OrderRootType.CLASSES);
                libModel.commit();
                addedLibraries.add(library);
            }
            return addedLibraries;
        }

        public void doChoose() {
            this.myLastChosen = this.choose(null, null);
        }
    }

    private abstract class ChooseAndAddAction
    extends PopupAction {
        public ChooseAndAddAction(int index, String title, Icon icon) {
            super(title, icon, index);
        }

        @Override
        protected final void executeImpl() {
            List<Library> libraries = this.doChoose();
            if (libraries.isEmpty()) {
                return;
            }
            int index0 = SimpleClasspathPanel.this.myListModel.size();
            for (Library library : libraries) {
                SimpleClasspathPanel.this.myListModel.addElement(library);
            }
            int index1 = SimpleClasspathPanel.this.myListModel.size() - 1;
            ListSelectionModel selectionModel = SimpleClasspathPanel.this.myList.getSelectionModel();
            int rowCount = SimpleClasspathPanel.this.myList.getModel().getSize();
            selectionModel.setSelectionInterval(rowCount - libraries.size(), rowCount - 1);
            SimpleClasspathPanel.scrollSelectionToVisible(SimpleClasspathPanel.this.myList);
            SimpleClasspathPanel.this.listChanged(new ListDataEvent(SimpleClasspathPanel.this.myListModel, 1, index0, index1));
        }

        @NotNull
        protected abstract List<Library> doChoose();
    }

    private class AddAction
    extends PopupActionGroupAction {
        public AddAction() {
            super(ProjectBundle.message((String)"module.add.action", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/general/add.png"));
        }

        @Override
        protected PopupAction[] createPopupActions() {
            int index = 1;
            ArrayList<ChooseAndAddAction> actions = new ArrayList<ChooseAndAddAction>();
            actions.add(new ChooseAndAddAction(index++, "Jar...", Icons.JAR_ICON){

                @Override
                @NotNull
                protected List<Library> doChoose() {
                    ChooseJarDialog dialog = new ChooseJarDialog(SimpleClasspathPanel.this, SimpleClasspathPanel.this.getVirtualFiles(), SimpleClasspathPanel.this.myDisposable);
                    dialog.doChoose();
                    List<Library> list = dialog.getChosenElements();
                    if (list == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/util/ui/classpath/SimpleClasspathPanel$AddAction$1.doChoose must not return null");
                    }
                    return list;
                }
            });
            actions.add(new ChooseAndAddAction(index++, "Library...", Icons.LIBRARY_ICON){

                @Override
                @NotNull
                protected List<Library> doChoose() {
                    final Set<VirtualFile> existingFiles = SimpleClasspathPanel.this.getVirtualFiles();
                    ChooseLibrariesDialog dialog = new ChooseLibrariesDialog(ProjectManager.getInstance().getDefaultProject(), "Choose Existing Libraries"){

                        @Override
                        protected boolean acceptsElement(Object element) {
                            if (!(element instanceof Library)) {
                                return true;
                            }
                            Library library = (Library)element;
                            return !existingFiles.containsAll(Arrays.asList(library.getFiles(OrderRootType.CLASSES)));
                        }

                        @Override
                        protected JComponent createCenterPanel() {
                            JPanel panel = new JPanel(new BorderLayout());
                            panel.add((Component)super.createCenterPanel(), "Center");
                            MultiLineLabel label = new MultiLineLabel("Please note that project-level and module-level libraries will not be\n\n  added as a whole but will be converted to jars and folders instead.");
                            label.setIcon(Messages.getWarningIcon());
                            label.setIcon(Messages.getWarningIcon());
                            panel.add((Component)label, "South");
                            return panel;
                        }
                    };
                    dialog.show();
                    List<Library> libraries = dialog.getSelectedLibraries();
                    ArrayList<Library> result = new ArrayList<Library>();
                    for (Library o : libraries) {
                        result.addAll(SimpleClasspathPanel.ensureApplicationLevel(o, existingFiles, SimpleClasspathPanel.this.myDisposable));
                    }
                    ArrayList<Library> arrayList = result;
                    if (arrayList == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/util/ui/classpath/SimpleClasspathPanel$AddAction$2.doChoose must not return null");
                    }
                    return arrayList;
                }
            });
            return actions.toArray(new PopupAction[actions.size()]);
        }
    }

    public static abstract class PopupActionGroupAction
    extends DumbAwareAction {
        private PopupAction[] myPopupActions;
        private Icon[] myIcons;

        protected PopupActionGroupAction(String text, String description, Icon icon) {
            super(text, description, icon);
        }

        private void initPopupActions() {
            if (this.myPopupActions == null) {
                this.myPopupActions = this.createPopupActions();
                this.myIcons = new Icon[this.myPopupActions.length];
                for (int idx = 0; idx < this.myPopupActions.length; ++idx) {
                    this.myIcons[idx] = this.myPopupActions[idx].getIcon();
                }
            }
        }

        protected abstract PopupAction[] createPopupActions();

        public void actionPerformed(AnActionEvent e) {
            this.initPopupActions();
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PopupAction>(null, this.myPopupActions, this.myIcons){

                public boolean isMnemonicsNavigationEnabled() {
                    return true;
                }

                public boolean isSelectable(PopupAction value) {
                    return true;
                }

                public PopupStep onChosen(final PopupAction selectedValue, boolean finalChoice) {
                    return this.doFinalStep(new Runnable(){

                        @Override
                        public void run() {
                            selectedValue.execute();
                        }
                    });
                }

                @NotNull
                public String getTextFor(PopupAction value) {
                    String string = "&" + value.getIndex() + "  " + value.getTitle();
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/util/ui/classpath/SimpleClasspathPanel$PopupActionGroupAction$1.getTextFor must not return null");
                    }
                    return string;
                }
            });
            popup.showUnderneathOf(e.getInputEvent().getComponent());
        }
    }

    public static abstract class PopupAction
    implements ActionListener {
        private final String myTitle;
        private final Icon myIcon;
        private final int myIndex;

        protected PopupAction(String title, Icon icon, int index) {
            this.myTitle = title;
            this.myIcon = icon;
            this.myIndex = index;
        }

        public String getTitle() {
            return this.myTitle;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public int getIndex() {
            return this.myIndex;
        }

        protected abstract void executeImpl();

        public void execute() {
            this.executeImpl();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.executeImpl();
        }
    }
}

