/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.reflect;

import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionImpl;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import gnu.trove.THashSet;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class DomExtensionsRegistrarImpl
implements DomExtensionsRegistrar {
    private final List<DomExtensionImpl> myAttributes = new SmartList();
    private final List<DomExtensionImpl> myFixeds = new SmartList();
    private final List<DomExtensionImpl> myCollections = new SmartList();
    private final Set<Object> myDependencies = new THashSet();
    private DomExtensionImpl myCustomChildrenType;

    public List<DomExtensionImpl> getAttributes() {
        return this.myAttributes;
    }

    public List<DomExtensionImpl> getFixeds() {
        return this.myFixeds;
    }

    public List<DomExtensionImpl> getCollections() {
        return this.myCollections;
    }

    public DomExtensionImpl getCustomChildrenType() {
        return this.myCustomChildrenType;
    }

    @NotNull
    public final DomExtension registerFixedNumberChildrenExtension(@NotNull XmlName name, @NotNull Type type, int count) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerFixedNumberChildrenExtension must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerFixedNumberChildrenExtension must not be null");
        }
        assert (count > 0);
        DomExtensionImpl domExtensionImpl = DomExtensionsRegistrarImpl.addExtension(this.myFixeds, name, type).setCount(count);
        if (domExtensionImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerFixedNumberChildrenExtension must not return null");
        }
        return domExtensionImpl;
    }

    @NotNull
    public DomExtension registerFixedNumberChildExtension(@NotNull XmlName name, @NotNull Type type) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerFixedNumberChildExtension must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerFixedNumberChildExtension must not be null");
        }
        DomExtension domExtension = this.registerFixedNumberChildrenExtension(name, type, 1);
        if (domExtension == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerFixedNumberChildExtension must not return null");
        }
        return domExtension;
    }

    @NotNull
    public DomExtension registerCollectionChildrenExtension(@NotNull XmlName name, @NotNull Type type) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerCollectionChildrenExtension must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerCollectionChildrenExtension must not be null");
        }
        DomExtensionImpl domExtensionImpl = DomExtensionsRegistrarImpl.addExtension(this.myCollections, name, type);
        if (domExtensionImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerCollectionChildrenExtension must not return null");
        }
        return domExtensionImpl;
    }

    @NotNull
    public DomExtension registerGenericAttributeValueChildExtension(@NotNull XmlName name, Type parameterType) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerGenericAttributeValueChildExtension must not be null");
        }
        DomExtensionImpl domExtensionImpl = DomExtensionsRegistrarImpl.addExtension(this.myAttributes, name, ParameterizedTypeImpl.make(GenericAttributeValue.class, new Type[]{parameterType}, null));
        if (domExtensionImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerGenericAttributeValueChildExtension must not return null");
        }
        return domExtensionImpl;
    }

    @NotNull
    public DomExtension registerAttributeChildExtension(@NotNull XmlName name, @NotNull Type type) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerAttributeChildExtension must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerAttributeChildExtension must not be null");
        }
        assert (GenericAttributeValue.class.isAssignableFrom(ReflectionUtil.getRawType((Type)type)));
        DomExtensionImpl domExtensionImpl = DomExtensionsRegistrarImpl.addExtension(this.myAttributes, name, type);
        if (domExtensionImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerAttributeChildExtension must not return null");
        }
        return domExtensionImpl;
    }

    @NotNull
    public DomExtension registerCustomChildrenExtension(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerCustomChildrenExtension must not be null");
        }
        assert (this.myCustomChildrenType == null);
        this.myCustomChildrenType = new DomExtensionImpl(type, null);
        if (this.myCustomChildrenType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/reflect/DomExtensionsRegistrarImpl.registerCustomChildrenExtension must not return null");
        }
        return this.myCustomChildrenType;
    }

    private static DomExtensionImpl addExtension(List<DomExtensionImpl> list, XmlName name, Type type) {
        DomExtensionImpl extension = new DomExtensionImpl(type, name);
        list.add(extension);
        return extension;
    }

    public final void addDependencies(Object[] deps) {
        this.myDependencies.addAll(Arrays.asList(deps));
    }

    public Object[] getDependencies() {
        return this.myDependencies.toArray();
    }
}

