/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.AbstractConvertContext;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.JvmPsiTypeConverterImpl;
import com.intellij.util.xml.ui.DomWrapper;
import com.intellij.util.xml.ui.EditorTextFieldControl;
import com.intellij.util.xml.ui.PsiClassControl;
import com.intellij.util.xml.ui.PsiTypePanel;
import org.jetbrains.annotations.NotNull;

public class PsiTypeControl
extends EditorTextFieldControl<PsiTypePanel> {
    public PsiTypeControl(DomWrapper<String> domWrapper, boolean commitOnEveryChange) {
        super(domWrapper, commitOnEveryChange);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected String getValue() {
        String string;
        String rawValue;
        block6: {
            String string2;
            rawValue = super.getValue();
            try {
                PsiType psiType = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeFromText(rawValue, null);
                String s = JvmPsiTypeConverterImpl.convertToString(psiType);
                if (s == null) break block6;
                string2 = s;
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
                break block6;
            }
            string = string2;
            if (string2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/PsiTypeControl.getValue must not return null");
            return string;
        }
        if ((string = rawValue) != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/PsiTypeControl.getValue must not return null");
    }

    private PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.getProject());
    }

    @Override
    protected void setValue(String value) {
        PsiType type = JvmPsiTypeConverterImpl.convertFromString(value, (ConvertContext)new AbstractConvertContext(){

            @NotNull
            public DomElement getInvocationElement() {
                DomElement domElement = PsiTypeControl.this.getDomElement();
                if (domElement == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/PsiTypeControl$1.getInvocationElement must not return null");
                }
                return domElement;
            }

            public PsiManager getPsiManager() {
                return PsiTypeControl.this.getPsiManager();
            }
        });
        if (type != null) {
            value = type.getCanonicalText();
        }
        super.setValue(value);
    }

    @Override
    protected EditorTextField getEditorTextField(@NotNull PsiTypePanel component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/ui/PsiTypeControl.getEditorTextField must not be null");
        }
        return ((ReferenceEditorWithBrowseButton)((Object)component.getComponent(0))).getEditorTextField();
    }

    @Override
    protected PsiTypePanel createMainComponent(PsiTypePanel boundedComponent, final Project project) {
        if (boundedComponent == null) {
            boundedComponent = new PsiTypePanel();
        }
        return PsiClassControl.initReferenceEditorWithBrowseButton(boundedComponent, new ReferenceEditorWithBrowseButton(null, project, new Function<String, Document>(){

            public Document fun(String s) {
                return JavaReferenceEditorUtil.createTypeDocument(s, PsiManager.getInstance((Project)project));
            }
        }, ""), this);
    }
}

