/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class XWatchesTreeActionBase
extends AnAction {
    protected static <T extends TreeNode> List<? extends T> getSelectedNodes(@NotNull XDebuggerTree tree, Class<T> nodeClass) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/frame/actions/XWatchesTreeActionBase.getSelectedNodes must not be null");
        }
        ArrayList<T> list = new ArrayList<T>();
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                Object element = selectionPath.getLastPathComponent();
                if (!nodeClass.isInstance(element)) continue;
                list.add(nodeClass.cast(element));
            }
        }
        return list;
    }

    public void update(AnActionEvent e) {
        boolean enabled = this.isEnabled(e);
        e.getPresentation().setEnabled(enabled);
    }

    protected abstract boolean isEnabled(AnActionEvent var1);
}

