/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerTreeState {
    private final NodeInfo myRootInfo;
    private Rectangle myLastVisibleNodeRect;

    private XDebuggerTreeState(@NotNull XDebuggerTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState.<init> must not be null");
        }
        this.myRootInfo = new NodeInfo("", "", false);
        ApplicationManager.getApplication().assertIsDispatchThread();
        XDebuggerTreeNode root = (XDebuggerTreeNode)tree.getTreeModel().getRoot();
        if (root != null) {
            this.addChildren(tree, this.myRootInfo, root);
        }
    }

    public XDebuggerTreeRestorer restoreState(@NotNull XDebuggerTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState.restoreState must not be null");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        XDebuggerTreeRestorer restorer = new XDebuggerTreeRestorer(tree, this.myLastVisibleNodeRect);
        restorer.restoreChildren((XDebuggerTreeNode)tree.getTreeModel().getRoot(), this.myRootInfo);
        return restorer;
    }

    public static XDebuggerTreeState saveState(@NotNull XDebuggerTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState.saveState must not be null");
        }
        return new XDebuggerTreeState(tree);
    }

    private void addChildren(XDebuggerTree tree, NodeInfo nodeInfo, XDebuggerTreeNode treeNode) {
        List<? extends XDebuggerTreeNode> children;
        if (tree.isExpanded(treeNode.getPath()) && (children = treeNode.getLoadedChildren()) != null) {
            nodeInfo.myExpanded = true;
            for (XDebuggerTreeNode xDebuggerTreeNode : children) {
                NodeInfo childInfo;
                TreePath path = xDebuggerTreeNode.getPath();
                Rectangle bounds = tree.getPathBounds(path);
                if (tree.getVisibleRect().contains(bounds)) {
                    this.myLastVisibleNodeRect = bounds;
                }
                if ((childInfo = XDebuggerTreeState.createNode(xDebuggerTreeNode, tree.isPathSelected(path))) == null) continue;
                nodeInfo.addChild(childInfo);
                this.addChildren(tree, childInfo, xDebuggerTreeNode);
            }
        }
    }

    @Nullable
    private static NodeInfo createNode(XDebuggerTreeNode node, boolean selected) {
        if (node instanceof XValueNodeImpl) {
            XValueNodeImpl valueNode = (XValueNodeImpl)node;
            String name = valueNode.getName();
            String value = valueNode.getValue();
            if (name != null && value != null) {
                return new NodeInfo(name, value, selected);
            }
        }
        return null;
    }

    public static class NodeInfo {
        private final String myName;
        private final String myValue;
        private boolean myExpanded;
        private final boolean mySelected;
        private Map<String, NodeInfo> myChidlren;

        public NodeInfo(String name, String value, boolean selected) {
            this.myName = name;
            this.myValue = value;
            this.mySelected = selected;
        }

        public void addChild(@NotNull NodeInfo child) {
            if (child == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState$NodeInfo.addChild must not be null");
            }
            if (this.myChidlren == null) {
                this.myChidlren = new HashMap<String, NodeInfo>();
            }
            this.myChidlren.put(child.myName, child);
        }

        public boolean isExpanded() {
            return this.myExpanded;
        }

        public String getName() {
            return this.myName;
        }

        public boolean isSelected() {
            return this.mySelected;
        }

        public String getValue() {
            return this.myValue;
        }

        @Nullable
        public NodeInfo getChild(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState$NodeInfo.getChild must not be null");
            }
            return this.myChidlren != null ? this.myChidlren.get(name) : null;
        }

        @Nullable
        public NodeInfo removeChild(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState$NodeInfo.removeChild must not be null");
            }
            return this.myChidlren != null ? this.myChidlren.remove(name) : null;
        }
    }
}

