/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.frame.WatchInplaceEditor;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchMessageNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchesRootNode
extends XDebuggerTreeNode {
    private List<WatchNode> myChildren = new ArrayList<WatchNode>();
    private List<XDebuggerTreeNode> myLoadedChildren;
    private XDebuggerEvaluator myCurrentEvaluator;

    public WatchesRootNode(XDebuggerTree tree, String[] watchExpressions) {
        super(tree, null, false);
        for (String watchExpression : watchExpressions) {
            this.myChildren.add(WatchMessageNode.createMessageNode(tree, this, watchExpression));
        }
    }

    public void updateWatches(@Nullable XDebuggerEvaluator evaluator) {
        this.myCurrentEvaluator = evaluator;
        ArrayList<WatchNode> newChildren = new ArrayList<WatchNode>();
        if (evaluator != null) {
            for (WatchNode child : this.myChildren) {
                String expression = child.getExpression();
                WatchMessageNode evaluatingNode = WatchMessageNode.createEvaluatingNode(this.myTree, this, expression);
                newChildren.add(evaluatingNode);
                evaluator.evaluate(expression, (XDebuggerEvaluator.XEvaluationCallback)new MyEvaluationCallback(evaluatingNode), null);
            }
        } else {
            for (WatchNode child : this.myChildren) {
                String expression = child.getExpression();
                newChildren.add(WatchMessageNode.createMessageNode(this.myTree, this, expression));
            }
        }
        this.myChildren = newChildren;
        this.myLoadedChildren = null;
        this.fireNodeChildrenChanged();
    }

    @Override
    protected List<? extends TreeNode> getChildren() {
        return this.myChildren;
    }

    @Nullable
    public List<? extends WatchNode> getAllChildren() {
        return this.myChildren;
    }

    @Override
    public List<? extends XDebuggerTreeNode> getLoadedChildren() {
        if (this.myLoadedChildren == null) {
            this.myLoadedChildren = new ArrayList<XDebuggerTreeNode>();
            for (WatchNode child : this.myChildren) {
                if (!(child instanceof WatchNodeImpl)) continue;
                this.myLoadedChildren.add((WatchNodeImpl)child);
            }
        }
        return this.myLoadedChildren;
    }

    @Override
    public void clearChildren() {
        this.updateWatches(this.myCurrentEvaluator);
    }

    private void replaceNode(WatchNode oldNode, WatchNode newNode) {
        for (int i = 0; i < this.myChildren.size(); ++i) {
            WatchNode child = this.myChildren.get(i);
            if (child != oldNode) continue;
            this.myChildren.set(i, newNode);
            if (newNode instanceof XValueContainerNode) {
                this.myLoadedChildren = null;
                this.fireNodeChildrenChanged();
                this.myTree.childrenLoaded(this, Collections.singletonList((XValueContainerNode)((Object)newNode)), false);
            } else {
                this.fireNodeChildrenChanged();
            }
            return;
        }
    }

    public void addWatchExpression(@Nullable XDebuggerEvaluator evaluator, @NotNull String expression, int index) {
        WatchMessageNode message;
        if (expression == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode.addWatchExpression must not be null");
        }
        WatchMessageNode watchMessageNode = message = evaluator != null ? WatchMessageNode.createEvaluatingNode(this.myTree, this, expression) : WatchMessageNode.createMessageNode(this.myTree, this, expression);
        if (index == -1) {
            this.myChildren.add(message);
        } else {
            this.myChildren.add(index, message);
        }
        if (evaluator != null) {
            evaluator.evaluate(expression, (XDebuggerEvaluator.XEvaluationCallback)new MyEvaluationCallback(message), null);
        }
        this.fireNodeChildrenChanged();
    }

    public int removeChildNode(XDebuggerTreeNode node) {
        int index = this.myChildren.indexOf(node);
        this.myChildren.remove(node);
        this.myLoadedChildren = null;
        this.fireNodeChildrenChanged();
        return index;
    }

    public void removeChildren(Collection<? extends XDebuggerTreeNode> nodes) {
        this.myChildren.removeAll(nodes);
        this.myLoadedChildren = null;
        this.fireNodeChildrenChanged();
    }

    public void addNewWatch() {
        this.editWatch(null);
    }

    public void editWatch(@Nullable WatchNode node) {
        int index;
        WatchMessageNode messageNode = WatchMessageNode.createMessageNode(this.myTree, this, "");
        int n = index = node != null ? this.myChildren.indexOf(node) : -1;
        if (index == -1) {
            this.myChildren.add(messageNode);
        } else {
            this.myChildren.set(index, messageNode);
        }
        this.fireNodeChildrenChanged();
        WatchInplaceEditor editor = new WatchInplaceEditor(this, messageNode, "watch", node);
        editor.show();
    }

    private class MyEvaluationCallback
    extends XEvaluationCallbackBase {
        private final WatchNode myResultPlace;

        public MyEvaluationCallback(WatchNode resultPlace) {
            if (resultPlace == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode$MyEvaluationCallback.<init> must not be null");
            }
            this.myResultPlace = resultPlace;
        }

        public void evaluated(final @NotNull XValue result) {
            if (result == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode$MyEvaluationCallback.evaluated must not be null");
            }
            DebuggerUIUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WatchesRootNode.this.replaceNode(MyEvaluationCallback.this.myResultPlace, new WatchNodeImpl(WatchesRootNode.this.myTree, WatchesRootNode.this, result, MyEvaluationCallback.this.myResultPlace.getExpression()));
                }
            });
        }

        public void errorOccurred(final @NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode$MyEvaluationCallback.errorOccurred must not be null");
            }
            DebuggerUIUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WatchesRootNode.this.replaceNode(MyEvaluationCallback.this.myResultPlace, WatchMessageNode.createErrorNode(WatchesRootNode.this.myTree, WatchesRootNode.this, MyEvaluationCallback.this.myResultPlace.getExpression(), errorMessage));
                }
            });
        }
    }
}

