/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dom;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.xml.XmlAttributeDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DomAttributeXmlDescriptor
implements XmlAttributeDescriptor {
    private final DomAttributeChildDescription myDescription;

    public DomAttributeXmlDescriptor(DomAttributeChildDescription description) {
        this.myDescription = description;
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isFixed() {
        return false;
    }

    public boolean hasIdType() {
        return false;
    }

    public boolean hasIdRefType() {
        return false;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    public boolean isEnumerated() {
        return false;
    }

    @Nullable
    public String[] getEnumeratedValues() {
        return null;
    }

    @Nullable
    public String validateValue(XmlElement context, String value) {
        return null;
    }

    public PsiElement getDeclaration() {
        return null;
    }

    @NonNls
    public String getName(PsiElement context) {
        return DomAttributeXmlDescriptor.getQualifiedAttributeName(context, this.myDescription.getXmlName());
    }

    static String getQualifiedAttributeName(PsiElement context, XmlName xmlName) {
        String localName = xmlName.getLocalName();
        if (context instanceof XmlTag) {
            String prefix;
            String ns;
            XmlTag tag = (XmlTag)context;
            DomInvocationHandler handler = DomManagerImpl.getDomManager(context.getProject()).getDomHandler(tag);
            if (handler != null && !(ns = handler.createEvaluatedXmlName(xmlName).getNamespace((XmlElement)tag, handler.getFile())).equals("") && !ns.equals(tag.getNamespace()) && StringUtil.isNotEmpty((String)(prefix = tag.getPrefixByNamespace(ns)))) {
                return prefix + ":" + localName;
            }
        }
        return localName;
    }

    @NonNls
    public String getName() {
        return this.getLocalName();
    }

    private String getLocalName() {
        return this.myDescription.getXmlName().getLocalName();
    }

    public void init(PsiElement element) {
        throw new UnsupportedOperationException("Method init not implemented in " + this.getClass());
    }

    public Object[] getDependences() {
        throw new UnsupportedOperationException("Method getDependences not implemented in " + this.getClass());
    }
}

