/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.util.ImageInfoReader;
import org.jetbrains.annotations.NotNull;

public class ImageInfoIndex
extends SingleEntryFileBasedIndexExtension<ImageInfo> {
    public static final ID<Integer, ImageInfo> INDEX_ID = ID.create((String)"ImageFileInfoIndex");
    private final FileBasedIndex.InputFilter myInputFilter = new FileBasedIndex.InputFilter(){

        @Override
        public boolean acceptInput(VirtualFile file) {
            return (file.getFileSystem() == LocalFileSystem.getInstance() || file.getFileSystem() instanceof TempFileSystem) && file.getFileType() == ImageFileTypeManager.getInstance().getImageFileType();
        }
    };
    private final DataExternalizer<ImageInfo> myValueExternalizer = new DataExternalizer<ImageInfo>(){

        public void save(DataOutput out, ImageInfo info) throws IOException {
            out.writeInt(info.width);
            out.writeInt(info.height);
            out.writeInt(info.bpp);
        }

        public ImageInfo read(DataInput in) throws IOException {
            return new ImageInfo(in.readInt(), in.readInt(), in.readInt());
        }
    };
    private final SingleEntryIndexer<ImageInfo> myDataIndexer = new SingleEntryIndexer<ImageInfo>(false){

        @Override
        protected ImageInfo computeValue(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/images/index/ImageInfoIndex$3.computeValue must not be null");
            }
            ImageInfoReader.Info info = ImageInfoReader.getInfo(inputData.getContent());
            return info != null ? new ImageInfo(info.width, info.height, info.bpp) : null;
        }
    };

    @Override
    public ID<Integer, ImageInfo> getName() {
        return INDEX_ID;
    }

    @Override
    public SingleEntryIndexer<ImageInfo> getIndexer() {
        return this.myDataIndexer;
    }

    public static void processValues(VirtualFile virtualFile, FileBasedIndex.ValueProcessor<ImageInfo> processor, Project project) {
        FileBasedIndex.getInstance().processValues(INDEX_ID, Math.abs(FileBasedIndex.getFileId(virtualFile)), virtualFile, processor, GlobalSearchScope.fileScope((Project)project, (VirtualFile)virtualFile));
    }

    @Override
    public DataExternalizer<ImageInfo> getValueExternalizer() {
        return this.myValueExternalizer;
    }

    @Override
    public FileBasedIndex.InputFilter getInputFilter() {
        return this.myInputFilter;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    public static class ImageInfo {
        public int width;
        public int height;
        public int bpp;

        public ImageInfo(int width, int height, int bpp) {
            this.width = width;
            this.height = height;
            this.bpp = bpp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageInfo imageInfo = (ImageInfo)o;
            if (this.bpp != imageInfo.bpp) {
                return false;
            }
            if (this.height != imageInfo.height) {
                return false;
            }
            return this.width == imageInfo.width;
        }

        public int hashCode() {
            int result = this.width;
            result = 31 * result + this.height;
            result = 31 * result + this.bpp;
            return result;
        }
    }
}

