/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.idea.Main;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.text.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NonNls;

public class ClassloaderUtil {
    @NonNls
    static final String FILE_CACHE = "fileCache";
    @NonNls
    static final String URL_CACHE = "urlCache";
    @NonNls
    public static final String PROPERTY_IGNORE_CLASSPATH = "ignore.classpath";
    private static final String ERROR = "Error";

    private ClassloaderUtil() {
    }

    public static void clearJarURLCache() {
        try {
            Class<?> jarFileFactory = Class.forName("sun.net.www.protocol.jar.JarFileFactory");
            Field fileCache = jarFileFactory.getDeclaredField(FILE_CACHE);
            Field urlCache = jarFileFactory.getDeclaredField(URL_CACHE);
            fileCache.setAccessible(true);
            fileCache.set(null, new HashMap());
            urlCache.setAccessible(true);
            urlCache.set(null, new HashMap());
        }
        catch (Exception e) {
            System.out.println("Failed to clear URL cache");
        }
    }

    public static Logger getLogger() {
        return Logger.getInstance((String)"ClassloaderUtil");
    }

    public static UrlClassLoader initClassloader(List<URL> classpathElements) {
        PathManager.loadProperties();
        try {
            ClassloaderUtil.addParentClasspath(classpathElements);
            ClassloaderUtil.addIDEALibraries(classpathElements);
            ClassloaderUtil.addAdditionalClassPath(classpathElements);
        }
        catch (IllegalArgumentException e) {
            if (Main.isHeadless()) {
                ClassloaderUtil.getLogger().error((Throwable)e);
            } else {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), e.getMessage(), ERROR, 1);
            }
            System.exit(1);
        }
        catch (MalformedURLException e) {
            if (Main.isHeadless()) {
                ClassloaderUtil.getLogger().error(e.getMessage());
            } else {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), e.getMessage(), ERROR, 1);
            }
            System.exit(1);
        }
        ClassloaderUtil.filterClassPath(classpathElements);
        UrlClassLoader newClassLoader = null;
        try {
            newClassLoader = new UrlClassLoader(classpathElements, null, true, true);
            if (!ClassloaderUtil.isLoadingOfExternalPluginsDisabled()) {
                try {
                    StartupActionScriptManager.executeActionScript();
                }
                catch (IOException e) {
                    String errorMessage = "Error executing plugin installation script: " + e.getMessage();
                    if (Main.isHeadless()) {
                        System.out.println(errorMessage);
                    }
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), errorMessage, ERROR, 1);
                }
            }
            Thread.currentThread().setContextClassLoader((ClassLoader)newClassLoader);
        }
        catch (Exception e) {
            Logger logger = ClassloaderUtil.getLogger();
            if (logger == null) {
                e.printStackTrace(System.err);
            }
            logger.error((Throwable)e);
        }
        return newClassLoader;
    }

    public static void filterClassPath(List<URL> classpathElements) {
        String ignoreProperty = System.getProperty(PROPERTY_IGNORE_CLASSPATH);
        if (ignoreProperty == null) {
            return;
        }
        Pattern pattern = Pattern.compile(ignoreProperty);
        Iterator<URL> i = classpathElements.iterator();
        while (i.hasNext()) {
            URL url = i.next();
            String u = url.toExternalForm();
            if (!pattern.matcher(u).matches()) continue;
            i.remove();
        }
    }

    public static void addParentClasspath(List<URL> aClasspathElements) throws MalformedURLException {
        ClassLoader loader = ClassloaderUtil.class.getClassLoader();
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)loader;
            aClasspathElements.addAll(Arrays.asList(urlClassLoader.getURLs()));
        } else {
            try {
                Class<?> antClassLoaderClass = Class.forName("org.apache.tools.ant.AntClassLoader");
                if (antClassLoaderClass.isInstance(loader) || loader.getClass().getName().equals("org.apache.tools.ant.AntClassLoader") || loader.getClass().getName().equals("org.apache.tools.ant.loader.AntClassLoader2")) {
                    String classpath = (String)antClassLoaderClass.getDeclaredMethod("getClasspath", ArrayUtil.EMPTY_CLASS_ARRAY).invoke((Object)loader, ArrayUtil.EMPTY_OBJECT_ARRAY);
                    StringTokenizer tokenizer = new StringTokenizer(classpath, File.separator, false);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        aClasspathElements.add(new File(token).toURI().toURL());
                    }
                } else {
                    ClassloaderUtil.getLogger().warn("Unknown classloader: " + loader.getClass().getName());
                }
            }
            catch (ClassCastException e) {
                ClassloaderUtil.getLogger().warn("Unknown classloader [CCE]: " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                ClassloaderUtil.getLogger().warn("Unknown classloader [CNFE]: " + loader.getClass().getName());
            }
            catch (NoSuchMethodException e) {
                ClassloaderUtil.getLogger().warn("Unknown classloader [NSME]: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                ClassloaderUtil.getLogger().warn("Unknown classloader [IAE]: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                ClassloaderUtil.getLogger().warn("Unknown classloader [ITE]: " + e.getMessage());
            }
        }
    }

    public static void addIDEALibraries(List<URL> classpathElements) {
        String ideaHomePath = PathManager.getHomePath();
        ClassloaderUtil.addAllFromLibFolder(ideaHomePath, classpathElements);
    }

    public static void addAllFromLibFolder(String aFolderPath, List<URL> classPath) {
        try {
            Class<ClassloaderUtil> aClass = ClassloaderUtil.class;
            String selfRoot = PathManager.getResourceRoot(aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
            URL selfRootUrl = new File(selfRoot).getAbsoluteFile().toURI().toURL();
            classPath.add(selfRootUrl);
            File libFolder = new File(aFolderPath + File.separator + "lib");
            ClassloaderUtil.addLibraries(classPath, libFolder, selfRootUrl);
            File antLib = new File(new File(libFolder, "ant"), "lib");
            ClassloaderUtil.addLibraries(classPath, antLib, selfRootUrl);
        }
        catch (MalformedURLException e) {
            ClassloaderUtil.getLogger().error((Throwable)e);
        }
    }

    public static void addLibraries(List<URL> classPath, File fromDir, URL selfRootUrl) throws MalformedURLException {
        File[] files = fromDir.listFiles();
        if (files != null) {
            for (File file : files) {
                URL url;
                if (!ClassloaderUtil.isJarOrZip(file) || selfRootUrl.equals(url = file.toURI().toURL())) continue;
                classPath.add(url);
            }
        }
    }

    public static boolean isJarOrZip(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String name = file.getName();
        return StringUtil.endsWithIgnoreCase((String)name, (String)".jar") || StringUtil.endsWithIgnoreCase((String)name, (String)".zip");
    }

    public static void addAdditionalClassPath(List<URL> classPath) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(System.getProperty("idea.additional.classpath", ""), File.pathSeparator, false);
            while (tokenizer.hasMoreTokens()) {
                String pathItem = tokenizer.nextToken();
                classPath.add(new File(pathItem).toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            ClassloaderUtil.getLogger().error((Throwable)e);
        }
    }

    public static boolean isLoadingOfExternalPluginsDisabled() {
        return !"true".equalsIgnoreCase(System.getProperty("idea.plugins.load", "true"));
    }
}

