/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.actions.GitRebaseActionBase;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitRebaseActionDialog;
import git4idea.rebase.GitRebaseUtils;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public abstract class GitAbstractRebaseResumeAction
extends GitRebaseActionBase {
    @Override
    protected GitLineHandler createHandler(Project project, List<VirtualFile> gitRoots, VirtualFile defaultRoot) {
        VirtualFile root;
        Iterator<VirtualFile> i = gitRoots.iterator();
        while (i.hasNext()) {
            if (GitRebaseUtils.isRebaseInTheProgress(i.next())) continue;
            i.remove();
        }
        if (gitRoots.size() == 0) {
            Messages.showErrorDialog((Project)project, (String)GitBundle.getString("rebase.action.no.root"), (String)GitBundle.getString("rebase.action.error"));
            return null;
        }
        if (gitRoots.size() == 1) {
            root = gitRoots.get(0);
        } else {
            GitRebaseActionDialog d;
            if (!gitRoots.contains(defaultRoot)) {
                defaultRoot = gitRoots.get(0);
            }
            if ((root = (d = new GitRebaseActionDialog(project, this.getActionTitle(), gitRoots, defaultRoot)).selectRoot()) == null) {
                return null;
            }
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.REBASE);
        h.addParameters(this.getOptionName());
        return h;
    }

    @Override
    protected void configureEditor(GitInteractiveRebaseEditorHandler editor) {
        editor.setRebaseEditorShown();
    }

    @NonNls
    protected abstract String getOptionName();

    protected abstract String getActionTitle();
}

