/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.checkin.GitPushUtils;
import git4idea.commands.GitCommand;
import git4idea.commands.GitFileUtils;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitConvertFilesDialog;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCheckinEnvironment
implements CheckinEnvironment {
    private static final Logger log = Logger.getInstance((String)GitCheckinEnvironment.class.getName());
    private final Project myProject;
    private final GitVcsSettings mySettings;
    private String myNextCommitAuthor;
    private Boolean myNextCommitIsPushed;
    private final VcsDirtyScopeManager myDirtyScopeManager;
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_PREFIX = "git-commit-msg-";
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_EXT = ".txt";

    public GitCheckinEnvironment(@NotNull Project project, @NotNull VcsDirtyScopeManager dirtyScopeManager, GitVcsSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/checkin/GitCheckinEnvironment.<init> must not be null");
        }
        if (dirtyScopeManager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/checkin/GitCheckinEnvironment.<init> must not be null");
        }
        this.myNextCommitAuthor = null;
        this.myNextCommitIsPushed = null;
        this.myProject = project;
        this.myDirtyScopeManager = dirtyScopeManager;
        this.mySettings = settings;
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return false;
    }

    @Nullable
    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel panel) {
        return new GitCheckinOptions();
    }

    @Nullable
    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        StringBuilder rc = new StringBuilder();
        for (VirtualFile root : GitUtil.gitRoots(Arrays.asList(filesToCheckin))) {
            VirtualFile mergeMsg = root.findFileByRelativePath(".git/MERGE_MSG");
            VirtualFile squashMsg = root.findFileByRelativePath(".git/SQUASH_MSG");
            if (mergeMsg == null && squashMsg == null) continue;
            try {
                String encoding = GitConfigUtil.getCommitEncoding(this.myProject, root);
                if (mergeMsg != null) {
                    rc.append(FileUtil.loadFileText((File)new File(mergeMsg.getPath()), (String)encoding));
                }
                if (squashMsg == null) continue;
                rc.append(FileUtil.loadFileText((File)new File(squashMsg.getPath()), (String)encoding));
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Unable to load merge message", (Throwable)e);
            }
        }
        if (rc.length() != 0) {
            return rc.toString();
        }
        return null;
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return GitBundle.getString("commit.action.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsException> commit(@NotNull List<Change> changes, @NotNull String message) {
        if (changes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/checkin/GitCheckinEnvironment.commit must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/checkin/GitCheckinEnvironment.commit must not be null");
        }
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        if (message.length() == 0) {
            exceptions.add(new VcsException("Empty commit message is not supported for the Git"));
            return exceptions;
        }
        Map<VirtualFile, List<Change>> sortedChanges = GitCheckinEnvironment.sortChangesByGitRoot(changes, exceptions);
        if (GitConvertFilesDialog.showDialogIfNeeded(this.myProject, this.mySettings, sortedChanges, exceptions)) {
            for (Map.Entry<VirtualFile, List<Change>> entry : sortedChanges.entrySet()) {
                HashSet<FilePath> files = new HashSet<FilePath>();
                VirtualFile root = entry.getKey();
                try {
                    File messageFile = this.createMessageFile(root, message);
                    try {
                        GitLineHandler pushHandler;
                        block24: {
                            HashSet<FilePath> added = new HashSet<FilePath>();
                            HashSet<FilePath> removed = new HashSet<FilePath>();
                            block15: for (Change change : entry.getValue()) {
                                switch (change.getType()) {
                                    case NEW: 
                                    case MODIFICATION: {
                                        added.add(change.getAfterRevision().getFile());
                                        continue block15;
                                    }
                                    case DELETED: {
                                        removed.add(change.getBeforeRevision().getFile());
                                        continue block15;
                                    }
                                    case MOVED: {
                                        added.add(change.getAfterRevision().getFile());
                                        removed.add(change.getBeforeRevision().getFile());
                                        continue block15;
                                    }
                                }
                                throw new IllegalStateException("Unknown change type: " + change.getType());
                            }
                            try {
                                if (!GitCheckinEnvironment.updateIndex(this.myProject, root, added, removed, exceptions)) break block24;
                                try {
                                    files.addAll(added);
                                    files.addAll(removed);
                                    GitCheckinEnvironment.commit(this.myProject, root, files, messageFile, this.myNextCommitAuthor);
                                }
                                catch (VcsException ex) {
                                    if (!GitCheckinEnvironment.isMergeCommit(ex)) {
                                        throw ex;
                                    }
                                    if (!GitCheckinEnvironment.mergeCommit(this.myProject, root, added, removed, messageFile, this.myNextCommitAuthor, exceptions)) {
                                        throw ex;
                                    }
                                }
                            }
                            finally {
                                if (!messageFile.delete()) {
                                    log.warn("Failed to remove temporary file: " + messageFile);
                                }
                            }
                        }
                        if (this.myNextCommitIsPushed == null || !this.myNextCommitIsPushed.booleanValue() || (pushHandler = GitPushUtils.preparePush(this.myProject, root)) == null) continue;
                        Collection<VcsException> problems = GitHandlerUtil.doSynchronouslyWithExceptions(pushHandler);
                        for (VcsException e : problems) {
                            if (GitCheckinEnvironment.isNoOrigin(e)) continue;
                            exceptions.add(e);
                        }
                    }
                    catch (VcsException e) {
                        exceptions.add(e);
                    }
                }
                catch (IOException ex) {
                    exceptions.add(new VcsException("Creation of commit message file failed", (Throwable)ex));
                }
            }
        }
        return exceptions;
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment, Object parameters) {
        return this.commit(changes, preparedComment);
    }

    private static boolean mergeCommit(final Project project, VirtualFile root, Set<FilePath> added, Set<FilePath> removed, File messageFile, String author, List<VcsException> exceptions) {
        String output;
        HashSet<FilePath> realAdded = new HashSet<FilePath>();
        HashSet<FilePath> realRemoved = new HashSet<FilePath>();
        GitSimpleHandler diff = new GitSimpleHandler(project, root, GitCommand.DIFF);
        diff.setNoSSH(true);
        diff.setSilent(true);
        diff.setStdoutSuppressed(true);
        diff.addParameters("--diff-filter=ADMRUX", "--name-status", "HEAD");
        diff.endOptions();
        try {
            output = diff.run();
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return false;
        }
        String rootPath = root.getPath();
        StringTokenizer lines = new StringTokenizer(output, "\n", false);
        block11: while (lines.hasMoreTokens()) {
            String line = lines.nextToken().trim();
            if (line.length() == 0) continue;
            String[] tk = line.split("[ \t]+");
            switch (tk[0].charAt(0)) {
                case 'A': 
                case 'M': {
                    realAdded.add(VcsUtil.getFilePath((String)(rootPath + "/" + tk[tk.length - 1])));
                    continue block11;
                }
                case 'D': {
                    realRemoved.add(VcsUtil.getFilePathForDeletedFile((String)(rootPath + "/" + tk[tk.length - 1]), (boolean)false));
                    continue block11;
                }
            }
            throw new IllegalStateException("Unexpected status: " + line);
        }
        realAdded.removeAll(added);
        realRemoved.removeAll(removed);
        if (realAdded.size() != 0 || realRemoved.size() != 0) {
            TreeSet<String> files = new TreeSet<String>();
            for (FilePath f : realAdded) {
                files.add(f.getPresentableUrl());
            }
            for (FilePath f : realRemoved) {
                files.add(f.getPresentableUrl());
            }
            final StringBuilder fileList = new StringBuilder();
            for (String f : files) {
                fileList.append("<li>");
                fileList.append(StringUtil.escapeXml((String)f));
                fileList.append("</li>");
            }
            final int[] rc = new int[1];
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        rc[0] = Messages.showOkCancelDialog((Project)project, (String)GitBundle.message("commit.partial.merge.message", fileList.toString()), (String)GitBundle.getString("commit.partial.merge.title"), null);
                    }
                });
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to invoke a message box on AWT thread", ex);
            }
            if (rc[0] != 0) {
                return false;
            }
            if (!GitCheckinEnvironment.updateIndex(project, root, realAdded, realRemoved, exceptions)) {
                return false;
            }
            for (FilePath f : realAdded) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(f);
            }
            for (FilePath f : realRemoved) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(f);
            }
        }
        try {
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.COMMIT);
            handler.setNoSSH(true);
            handler.addParameters("-F", messageFile.getAbsolutePath());
            if (author != null) {
                handler.addParameters("--author=" + author);
            }
            handler.endOptions();
            handler.run();
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return false;
        }
        return true;
    }

    private static boolean isMergeCommit(VcsException ex) {
        return -1 != ex.getMessage().indexOf("fatal: cannot do a partial commit during a merge.");
    }

    private static boolean isNoOrigin(VcsException ex) {
        return ex.getMessage().indexOf("': unable to chdir or not a git archive") != -1;
    }

    private static boolean updateIndex(Project project, VirtualFile root, Collection<FilePath> added, Collection<FilePath> removed, List<VcsException> exceptions) {
        boolean rc = true;
        if (!added.isEmpty()) {
            try {
                GitFileUtils.addPaths(project, root, added);
            }
            catch (VcsException ex) {
                exceptions.add(ex);
                rc = false;
            }
        }
        if (!removed.isEmpty()) {
            try {
                GitFileUtils.delete(project, root, removed, "--ignore-unmatch");
            }
            catch (VcsException ex) {
                exceptions.add(ex);
                rc = false;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createMessageFile(VirtualFile root, String message) throws IOException {
        File file = File.createTempFile(GIT_COMMIT_MSG_FILE_PREFIX, GIT_COMMIT_MSG_FILE_EXT);
        file.deleteOnExit();
        String encoding = GitConfigUtil.getCommitEncoding(this.myProject, root);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        try {
            out.write(message);
        }
        finally {
            ((Writer)out).close();
        }
        return file;
    }

    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> files) {
        Map<VirtualFile, List<FilePath>> sortedFiles;
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilePathsByGitRoot(files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<FilePath>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.delete(this.myProject, root, (Collection<FilePath>)e.getValue(), new String[0]);
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    private static void commit(Project project, VirtualFile root, Collection<FilePath> files, File message, String nextCommitAuthor) throws VcsException {
        boolean isFirst = true;
        for (List<String> paths : GitFileUtils.chunkPaths(root, files)) {
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.COMMIT);
            handler.setNoSSH(true);
            if (isFirst) {
                isFirst = false;
            } else {
                handler.addParameters("--amend");
            }
            handler.addParameters("--only", "-F", message.getAbsolutePath());
            if (nextCommitAuthor != null) {
                handler.addParameters("--author=" + nextCommitAuthor);
            }
            handler.endOptions();
            handler.addParameters(paths);
            handler.run();
        }
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        Map<VirtualFile, List<VirtualFile>> sortedFiles;
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilesByGitRoot(files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<VirtualFile>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.addFiles(this.myProject, root, (Collection<VirtualFile>)e.getValue());
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    private static Map<VirtualFile, List<Change>> sortChangesByGitRoot(@NotNull List<Change> changes, List<VcsException> exceptions) {
        if (changes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/checkin/GitCheckinEnvironment.sortChangesByGitRoot must not be null");
        }
        HashMap<VirtualFile, List<Change>> result = new HashMap<VirtualFile, List<Change>>();
        for (Change change : changes) {
            VirtualFile vcsRoot;
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            assert (beforeRevision != null || afterRevision != null);
            FilePath filePath = afterRevision != null ? afterRevision.getFile() : beforeRevision.getFile();
            try {
                vcsRoot = GitUtil.getGitRoot(filePath.getParentPath());
            }
            catch (VcsException e) {
                exceptions.add(e);
                continue;
            }
            ArrayList<Change> changeList = (ArrayList<Change>)result.get(vcsRoot);
            if (changeList == null) {
                changeList = new ArrayList<Change>();
                result.put(vcsRoot, changeList);
            }
            changeList.add(change);
        }
        return result;
    }

    private void markRootDirty(VirtualFile root) {
        this.myDirtyScopeManager.dirDirtyRecursively(root);
    }

    public void setNextCommitIsPushed(Boolean nextCommitIsPushed) {
        this.myNextCommitIsPushed = nextCommitIsPushed;
    }

    private class GitCheckinOptions
    implements RefreshableOnComponent {
        private final JPanel myPanel = new JPanel(new GridBagLayout());
        private final JComboBox myAuthor;

        GitCheckinOptions() {
            Insets insets = new Insets(2, 2, 2, 2);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.insets = insets;
            JLabel authorLabel = new JLabel(GitBundle.message("commit.author", new Object[0]));
            this.myPanel.add((Component)authorLabel, c);
            c = new GridBagConstraints();
            c.anchor = 10;
            c.insets = insets;
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1.0;
            c.fill = 2;
            this.myAuthor = new JComboBox<String>(GitCheckinEnvironment.this.mySettings.getCommitAuthors());
            this.myAuthor.insertItemAt("", 0);
            this.myAuthor.setSelectedItem("");
            this.myAuthor.setEditable(true);
            authorLabel.setLabelFor(this.myAuthor);
            this.myAuthor.setToolTipText(GitBundle.getString("commit.author.tooltip"));
            this.myPanel.add((Component)this.myAuthor, c);
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public void refresh() {
            this.myAuthor.setSelectedItem("");
            GitCheckinEnvironment.this.myNextCommitAuthor = null;
            GitCheckinEnvironment.this.myNextCommitIsPushed = null;
        }

        public void saveState() {
            String author = (String)this.myAuthor.getSelectedItem();
            GitCheckinEnvironment.this.myNextCommitAuthor = author.length() == 0 ? null : author;
            if (author.length() == 0) {
                GitCheckinEnvironment.this.myNextCommitAuthor = null;
            } else {
                GitCheckinEnvironment.this.myNextCommitAuthor = author;
                GitCheckinEnvironment.this.mySettings.saveCommitAuthor(author);
            }
        }

        public void restoreState() {
            this.refresh();
        }
    }
}

