/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.actions.GitRepositoryAction;
import git4idea.i18n.GitBundle;
import git4idea.merge.MergeChangeCollector;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;

public class GitMergeUtil {
    public static final String DEFAULT_STRATEGY = GitBundle.getString("merge.default.strategy");

    private GitMergeUtil() {
    }

    @NonNls
    public static String[] getMergeStrategies(int branchCount) {
        if (branchCount < 0) {
            throw new IllegalArgumentException("Branch count must be non-negative: " + branchCount);
        }
        switch (branchCount) {
            case 0: {
                return new String[]{DEFAULT_STRATEGY};
            }
            case 1: {
                return new String[]{DEFAULT_STRATEGY, "resolve", "recursive", "octopus", "ours", "subtree"};
            }
        }
        return new String[]{DEFAULT_STRATEGY, "octopus", "ours"};
    }

    public static void setupNoCommitCheckbox(final JCheckBox addLogInformationCheckBox, final JTextField commitMessage, final JCheckBox noCommitCheckBox) {
        noCommitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = noCommitCheckBox.isSelected();
                if (commitMessage != null) {
                    commitMessage.setEnabled(!selected);
                }
                if (selected) {
                    addLogInformationCheckBox.setSelected(false);
                }
                addLogInformationCheckBox.setEnabled(!selected);
            }
        });
    }

    public static void setupStrategies(final ElementsChooser<String> branchChooser, final JComboBox strategy) {
        ElementsChooser.ElementsMarkListener<String> listener = new ElementsChooser.ElementsMarkListener<String>(){

            private void updateStrategies(List<String> elements) {
                strategy.removeAllItems();
                for (String s : GitMergeUtil.getMergeStrategies(elements.size())) {
                    strategy.addItem(s);
                }
                strategy.setSelectedItem(DEFAULT_STRATEGY);
            }

            public void elementMarkChanged(String element, boolean isMarked) {
                List elements = branchChooser.getMarkedElements();
                if (elements.size() == 0) {
                    strategy.setEnabled(false);
                    this.updateStrategies(elements);
                } else {
                    strategy.setEnabled(true);
                    this.updateStrategies(elements);
                }
            }
        };
        listener.elementMarkChanged(null, true);
        branchChooser.addElementsMarkListener((ElementsChooser.ElementsMarkListener)listener);
    }

    public static void showUpdates(GitRepositoryAction action, final Project project, List<VcsException> exceptions, VirtualFile root, GitRevisionNumber currentRev, final Label beforeLabel, final String actionName, final ActionInfo actionInfo) {
        final UpdatedFiles files = UpdatedFiles.create();
        MergeChangeCollector collector = new MergeChangeCollector(project, root, currentRev, files);
        collector.collect(exceptions);
        if (exceptions.size() != 0) {
            return;
        }
        action.delayTask(new TransactionRunnable(){

            public void run(List<VcsException> exceptionList) {
                ProjectLevelVcsManagerEx manager = (ProjectLevelVcsManagerEx)ProjectLevelVcsManager.getInstance((Project)project);
                UpdateInfoTree tree = manager.showUpdateProjectInfo(files, actionName, actionInfo);
                tree.setBefore(beforeLabel);
                tree.setAfter(LocalHistory.putSystemLabel((Project)project, (String)"After update"));
            }
        });
        final Collection unmergedNames = files.getGroupById("MERGED_WITH_CONFLICTS").getFiles();
        if (!unmergedNames.isEmpty()) {
            action.delayTask(new TransactionRunnable(){

                public void run(List<VcsException> exceptionList) {
                    LocalFileSystem lfs = LocalFileSystem.getInstance();
                    ArrayList<VirtualFile> unmerged = new ArrayList<VirtualFile>();
                    for (String fileName : unmergedNames) {
                        VirtualFile f = lfs.findFileByPath(fileName);
                        if (f == null) continue;
                        unmerged.add(f);
                    }
                    AbstractVcsHelper.getInstance((Project)project).showMergeDialog(unmerged, GitVcs.getInstance(project).getMergeProvider());
                }
            });
        }
    }
}

