/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;

abstract class CreateClassActionBase
implements IntentionAction {
    protected final GrReferenceElement myRefElement;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.annotator.intentions.CreateClassActionBase");

    public CreateClassActionBase(GrReferenceElement refElement) {
        this.myRefElement = refElement;
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("create.class.text", this.myRefElement.getReferenceName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.class.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase.isAvailable must not be null");
        }
        return true;
    }

    public boolean startInWriteAction() {
        return true;
    }

    static PsiClass createClassByType(final PsiDirectory directory, final String name, final PsiManager manager, final PsiElement contextElement) {
        return (PsiClass)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                try {
                    PsiClass targetClass = null;
                    try {
                        PsiFile file = GroovyTemplatesFactory.createFromTemplate(directory, name, name + ".groovy", "GroovyClass.groovy", new String[0]);
                        for (PsiElement element : file.getChildren()) {
                            if (!(element instanceof PsiClass)) continue;
                            targetClass = (PsiClass)element;
                            break;
                        }
                        if (targetClass == null) {
                            throw new IncorrectOperationException(GroovyBundle.message("no.class.in.file.template", new Object[0]));
                        }
                    }
                    catch (IncorrectOperationException e) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Messages.showErrorDialog((String)GroovyBundle.message("cannot.create.class.error.text", name, e.getLocalizedMessage()), (String)GroovyBundle.message("cannot.create.class.error.title", new Object[0]));
                            }
                        });
                        return null;
                    }
                    PsiModifierList modifiers = targetClass.getModifierList();
                    if (!JavaPsiFacade.getInstance((Project)manager.getProject()).getResolveHelper().isAccessible((PsiMember)targetClass, contextElement, null) && modifiers != null) {
                        modifiers.setModifierProperty("public", true);
                    }
                    return targetClass;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
        });
    }

    static Editor putCursor(Project project, @NotNull PsiFile targetFile, PsiElement element) {
        if (targetFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase.putCursor must not be null");
        }
        TextRange range = element.getTextRange();
        int textOffset = range.getStartOffset();
        VirtualFile virtualFile = targetFile.getVirtualFile();
        if (virtualFile != null) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile, textOffset);
            return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        }
        return null;
    }
}

