/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GroovyAssignmentToForLoopParameterInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Assignment issues" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentToForLoopParameterInspection.getGroupDisplayName must not return null");
        }
        return "Assignment issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Assignment to for-loop parameter" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentToForLoopParameterInspection.getDisplayName must not return null");
        }
        return "Assignment to for-loop parameter";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Assignment to for-loop parameter '#ref' #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitAssignmentExpression(GrAssignmentExpression grAssignmentExpression) {
            super.visitAssignmentExpression(grAssignmentExpression);
            GrExpression lhs = grAssignmentExpression.getLValue();
            if (!(lhs instanceof GrReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)lhs).resolve();
            if (referent == null) {
                return;
            }
            if (!(referent instanceof GrParameter)) {
                return;
            }
            if (!(referent.getParent() instanceof GrForInClause)) {
                return;
            }
            this.registerError(lhs);
        }
    }
}

