/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.gpath;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSuperReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrThisReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GroovySetterCallCanBePropertyAccessInspection
extends BaseInspection {
    private final ReplaceWithPropertyAccessFix fix = new ReplaceWithPropertyAccessFix();

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("GPath inspections" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/gpath/GroovySetterCallCanBePropertyAccessInspection.getGroupDisplayName must not return null");
        }
        return "GPath inspections";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Setter call can be property access" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/gpath/GroovySetterCallCanBePropertyAccessInspection.getDisplayName must not return null");
        }
        return "Setter call can be property access";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Call to '#ref' can be property access #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    public GroovyFix buildFix(PsiElement location) {
        return this.fix;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        @NonNls
        private static final String SET_PREFIX = "set";

        private Visitor() {
        }

        @Override
        public void visitMethodCallExpression(GrMethodCallExpression grMethodCallExpression) {
            super.visitMethodCallExpression(grMethodCallExpression);
            GrArgumentList args = grMethodCallExpression.getArgumentList();
            if (args == null) {
                return;
            }
            if (args.getExpressionArguments().length != 1) {
                return;
            }
            if (args.getNamedArguments().length != 0) {
                return;
            }
            GrExpression methodExpression = grMethodCallExpression.getInvokedExpression();
            if (!(methodExpression instanceof GrReferenceExpression)) {
                return;
            }
            GrReferenceExpression referenceExpression = (GrReferenceExpression)methodExpression;
            String name = referenceExpression.getReferenceName();
            if (name == null || !name.startsWith(SET_PREFIX)) {
                return;
            }
            if (SET_PREFIX.equals(name)) {
                return;
            }
            String tail = StringUtil.trimStart((String)name, (String)SET_PREFIX);
            if (!tail.equals(StringUtil.capitalize((String)tail))) {
                return;
            }
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier == null || qualifier instanceof GrThisReferenceExpression || qualifier instanceof GrSuperReferenceExpression) {
                return;
            }
            this.registerMethodCallError(grMethodCallExpression, new Object[0]);
        }
    }

    private static class ReplaceWithPropertyAccessFix
    extends GroovyFix {
        private ReplaceWithPropertyAccessFix() {
        }

        @NotNull
        public String getName() {
            if ("Replace with property access" == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/gpath/GroovySetterCallCanBePropertyAccessInspection$ReplaceWithPropertyAccessFix.getName must not return null");
            }
            return "Replace with property access";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement referenceName = descriptor.getPsiElement();
            String setter = referenceName.getText();
            String propertyName = Character.toLowerCase(setter.charAt(3)) + setter.substring(4);
            GrReferenceExpression invokedExpression = (GrReferenceExpression)referenceName.getParent();
            GrMethodCallExpression callExpression = (GrMethodCallExpression)invokedExpression.getParent();
            GrArgumentList args = callExpression.getArgumentList();
            assert (args != null);
            GrExpression arg = args.getExpressionArguments()[0];
            ReplaceWithPropertyAccessFix.replaceExpression(callExpression, invokedExpression.getQualifierExpression().getText() + '.' + propertyName + " = " + arg.getText());
        }
    }
}

