/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ModuleSettings;
import com.intellij.openapi.module.StdModuleTypes;
import java.util.List;
import org.jdom.Element;

public class GroovyModuleConverter
extends ConversionProcessor<ModuleSettings> {
    public boolean isConversionNeeded(ModuleSettings moduleSettings) {
        if ("GRAILS_MODULE".equals(moduleSettings.getModuleType())) {
            return true;
        }
        if (!moduleSettings.getFacetElements("Grails").isEmpty()) {
            return true;
        }
        return !moduleSettings.getFacetElements("Groovy").isEmpty();
    }

    public void process(ModuleSettings moduleSettings) throws CannotConvertException {
        Element[] facetElements;
        Element facetManagerElement;
        if ("GRAILS_MODULE".equals(moduleSettings.getModuleType())) {
            moduleSettings.setModuleType(StdModuleTypes.JAVA.getId());
        }
        if ((facetManagerElement = moduleSettings.getComponentElement("FacetManager")) == null) {
            return;
        }
        for (Element facetElement : facetElements = GroovyModuleConverter.getChildren(facetManagerElement, "facet")) {
            String facetType = facetElement.getAttributeValue("type");
            if (!"Grails".equals(facetType) && !"Groovy".equals(facetType)) continue;
            facetElement.detach();
        }
    }

    private static Element[] getChildren(Element parent, String name) {
        List children = parent.getChildren(name);
        return children.toArray(new Element[children.size()]);
    }
}

