/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.groovy.editor.selection.GroovyBasicSelectioner;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;

public class GroovyGStringSelectioner
extends GroovyBasicSelectioner {
    public boolean canSelect(PsiElement e) {
        PsiElement parent = e.getParent();
        return parent instanceof GrStringInjection || parent instanceof GrString;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        PsiElement parent = e.getParent();
        if (parent instanceof GrString) {
            TextRange selection = new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
            TextRange range = GroovyGStringSelectioner.getLineTextRange(e, cursorOffset);
            ranges.add(range);
            if (selection.contains(range)) {
                PsiElement firstChild = parent.getFirstChild();
                PsiElement lastChild = parent.getLastChild();
                if (firstChild.getNode().getElementType() == GroovyTokenTypes.mGSTRING_BEGIN) {
                    firstChild = firstChild.getNextSibling();
                }
                if (lastChild.getNode().getElementType() == GroovyTokenTypes.mGSTRING_END) {
                    lastChild = lastChild.getPrevSibling();
                }
                if (firstChild != null && lastChild != null) {
                    range = new TextRange(firstChild.getTextOffset(), lastChild.getTextOffset() + lastChild.getTextLength());
                    ranges.add(range);
                }
                if (selection.contains(range) || firstChild == null || lastChild == null) {
                    ranges.add(parent.getTextRange());
                }
            }
        } else if (parent instanceof GrStringInjection) {
            if (e instanceof GrReferenceExpression) {
                ArrayList r = new ArrayList(2);
                SelectWordUtil.addWordSelection((boolean)editor.getSettings().isCamelWords(), (CharSequence)editorText, (int)cursorOffset, r);
                for (TextRange textRange : r) {
                    if (editorText.charAt(textRange.getStartOffset()) == '$') {
                        textRange = new TextRange(textRange.getStartOffset() + 1, textRange.getEndOffset());
                    }
                    ranges.add(textRange);
                }
            }
            ranges.add(parent.getTextRange());
            ranges.add(e.getTextRange());
        }
        return ranges;
    }

    private static TextRange getLineTextRange(PsiElement e, int cursorOffset) {
        int i;
        ASTNode node;
        assert (e.getParent() instanceof GrString);
        PsiElement next = e;
        int startOffset = cursorOffset;
        int endOffset = cursorOffset;
        if (e.getNode().getElementType() == GroovyTokenTypes.mGSTRING_CONTENT) {
            int cur;
            String text = e.getText();
            int index = -1;
            while ((cur = text.indexOf(10, index + 1)) >= 0 && cur + e.getTextOffset() <= cursorOffset) {
                index = cur;
            }
            if (index >= 0) {
                startOffset = e.getTextOffset() + index + 1;
            }
            if ((index = text.indexOf(10, cursorOffset - e.getTextOffset())) >= 0) {
                endOffset = e.getTextOffset() + index + 1;
            }
        }
        if (startOffset == cursorOffset) {
            IElementType type;
            while (next != null && (node = next.getNode()) != null && (type = node.getElementType()) != GroovyTokenTypes.mGSTRING_BEGIN) {
                if (type == GroovyTokenTypes.mGSTRING_CONTENT && (i = next.getText().lastIndexOf(10)) >= 0) {
                    startOffset = next.getTextOffset() + i + 1;
                    break;
                }
                startOffset = next.getTextOffset();
                next = next.getPrevSibling();
            }
        }
        if (endOffset == cursorOffset) {
            for (next = e; next != null && (node = next.getNode()) != null; next = next.getNextSibling()) {
                IElementType type = node.getElementType();
                if (type == GroovyTokenTypes.mGSTRING_END) {
                    endOffset = next.getTextOffset();
                    break;
                }
                if (type == GroovyTokenTypes.mGSTRING_CONTENT && (i = next.getText().indexOf(10)) >= 0) {
                    endOffset = next.getTextOffset() + i + 1;
                    break;
                }
                endOffset = next.getTextOffset() + next.getTextLength();
            }
        }
        return new TextRange(startOffset, endOffset);
    }
}

