/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.processors;

import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.formatter.GroovyBlock;
import org.jetbrains.plugins.groovy.formatter.models.spacing.SpacingTokens;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public abstract class GroovySpacingProcessorBasic
extends SpacingTokens
implements GroovyElementTypes {
    private static final Spacing NO_SPACING_WITH_NEWLINE = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)1);
    private static final Spacing NO_SPACING = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
    private static final Spacing COMMON_SPACING = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)100);
    private static final Spacing COMMON_SPACING_WITH_NL = Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)100);
    private static final Spacing IMPORT_BETWEEN_SPACING = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)100);
    private static final Spacing IMPORT_OTHER_SPACING = Spacing.createSpacing((int)0, (int)0, (int)2, (boolean)true, (int)100);
    private static final Spacing LAZY_SPACING = Spacing.createSpacing((int)0, (int)239, (int)0, (boolean)true, (int)100);

    public static Spacing getSpacing(GroovyBlock child1, GroovyBlock child2, CodeStyleSettings settings) {
        ASTNode leftNode = child1.getNode();
        ASTNode rightNode = child2.getNode();
        if (!child1.getNode().getTextRange().equals((Object)child1.getTextRange()) || !child2.getNode().getTextRange().equals((Object)child2.getTextRange())) {
            return NO_SPACING;
        }
        IElementType leftType = leftNode.getElementType();
        if (mLT == leftType && rightNode.getPsi() instanceof GrTypeParameter || mGT == rightNode.getElementType() && leftNode.getPsi() instanceof GrTypeParameter || mIDENT == leftType && rightNode.getPsi() instanceof GrTypeParameterList) {
            return NO_SPACING;
        }
        if (mLPAREN.equals(rightNode.getElementType()) && rightNode.getPsi().getParent().getNode() != null && METHOD_DEFS.contains(rightNode.getPsi().getParent().getNode().getElementType())) {
            return NO_SPACING;
        }
        if (((Object)((Object)ARGUMENTS)).equals(rightNode.getElementType())) {
            return NO_SPACING;
        }
        if (mLBRACK.equals(rightNode.getElementType()) && rightNode.getPsi().getParent().getNode() != null && INDEX_OR_ARRAY.contains(rightNode.getPsi().getParent().getNode().getElementType()) || ((Object)((Object)ARRAY_DECLARATOR)).equals(rightNode.getElementType())) {
            return NO_SPACING;
        }
        if (METHOD_DEFS.contains(leftType)) {
            return Spacing.createSpacing((int)0, (int)0, (int)(settings.BLANK_LINES_AROUND_METHOD + 1), (boolean)settings.KEEP_LINE_BREAKS, (int)100);
        }
        if (METHOD_DEFS.contains(rightNode.getElementType())) {
            if (leftNode.getElementType() == GROOVY_DOC_COMMENT) {
                return Spacing.createSpacing((int)0, (int)0, (int)settings.BLANK_LINES_AROUND_METHOD, (boolean)settings.KEEP_LINE_BREAKS, (int)0);
            }
            return Spacing.createSpacing((int)0, (int)0, (int)(settings.BLANK_LINES_AROUND_METHOD + 1), (boolean)settings.KEEP_LINE_BREAKS, (int)100);
        }
        IElementType rightType = rightNode.getElementType();
        if (leftType == mLCURLY && rightType == PARAMETERS_LIST) {
            return LAZY_SPACING;
        }
        if (LEFT_BRACES.contains(leftType) || RIGHT_BRACES.contains(rightType)) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if ((mLT.equals(leftType) || mGT.equals(rightNode.getElementType())) && leftNode.getPsi().getParent() != null && leftNode.getPsi().getParent() instanceof GrTypeArgumentList) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (rightNode.getPsi() != null && rightNode.getPsi() instanceof GrTypeArgumentList) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (PUNCTUATION_SIGNS.contains(rightNode.getElementType()) || mCOLON.equals(rightNode.getElementType()) && !(rightNode.getPsi().getParent() instanceof GrConditionalExpression)) {
            return NO_SPACING;
        }
        if (GroovyTokenTypes.DOTS.contains(leftType)) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (((Object)((Object)IMPORT_STATEMENT)).equals(leftType) && ((Object)((Object)IMPORT_STATEMENT)).equals(rightNode.getElementType())) {
            return IMPORT_BETWEEN_SPACING;
        }
        if (((Object)((Object)IMPORT_STATEMENT)).equals(leftType) && !((Object)((Object)IMPORT_STATEMENT)).equals(rightNode.getElementType()) && !mSEMI.equals(rightNode.getElementType()) || !((Object)((Object)IMPORT_STATEMENT)).equals(leftType) && !mSEMI.equals(leftType) && ((Object)((Object)IMPORT_STATEMENT)).equals(rightNode.getElementType())) {
            return IMPORT_OTHER_SPACING;
        }
        if ((((Object)((Object)VARIABLE_DEFINITION)).equals(leftType) || ((Object)((Object)VARIABLE_DEFINITION)).equals(rightNode.getElementType())) && !(leftNode.getTreeNext() instanceof PsiErrorElement)) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)100);
        }
        if (mLT.equals(leftType) && mLT.equals(rightNode.getElementType()) || mGT.equals(leftType) && mGT.equals(rightNode.getElementType())) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (PREFIXES.contains(leftType) || POSTFIXES.contains(rightNode.getElementType()) || PREFIXES_OPTIONAL.contains(leftType) && leftNode.getPsi().getParent() instanceof GrUnaryExpression) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (RANGES.contains(leftType) || RANGES.contains(rightNode.getElementType())) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (leftNode.getPsi().getParent() != null && leftNode.getPsi().getParent().equals(rightNode.getPsi().getParent()) && leftNode.getPsi().getParent() instanceof GrString) {
            return NO_SPACING;
        }
        if (GroovySpacingProcessorBasic.isDollarInGStringInjection(leftNode) || GroovySpacingProcessorBasic.isDollarInGStringInjection(rightNode)) {
            return NO_SPACING;
        }
        if (leftNode.getPsi().getParent() instanceof GrStringInjection && rightNode.getPsi().getParent() instanceof GrString && rightNode.getPsi().getParent().equals(leftNode.getPsi().getParent().getParent())) {
            return NO_SPACING;
        }
        if (mGDOC_ASTERISKS == leftType && mGDOC_COMMENT_DATA == rightNode.getElementType()) {
            String text = rightNode.getText();
            if (text.length() > 0 && !text.startsWith(" ")) {
                return COMMON_SPACING;
            }
            return NO_SPACING;
        }
        if (leftType == mGDOC_TAG_VALUE_TOKEN && rightType == mGDOC_COMMENT_DATA) {
            return LAZY_SPACING;
        }
        PsiElement left = leftNode.getPsi();
        PsiElement right = rightNode.getPsi();
        if (left instanceof GrStatement && right instanceof GrStatement && left.getParent() instanceof GrStatementOwner && right.getParent() instanceof GrStatementOwner) {
            return COMMON_SPACING_WITH_NL;
        }
        if (rightType == mGDOC_INLINE_TAG_END || leftType == mGDOC_INLINE_TAG_START || rightType == mGDOC_INLINE_TAG_START || leftType == mGDOC_INLINE_TAG_END) {
            return NO_SPACING;
        }
        if (leftType == CLASS_TYPE_ELEMENT && rightType == mTRIPLE_DOT) {
            return NO_SPACING;
        }
        return COMMON_SPACING;
    }

    private static boolean isDollarInGStringInjection(ASTNode node) {
        return node.getElementType() == mDOLLAR && node.getTreeParent().getElementType() == GSTRING_INJECTION;
    }
}

