/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.SplitElseIfPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class SplitElseIfIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        SplitElseIfPredicate splitElseIfPredicate = new SplitElseIfPredicate();
        if (splitElseIfPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/control/SplitElseIfIntention.getElementPredicate must not return null");
        }
        return splitElseIfPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/control/SplitElseIfIntention.processIntention must not be null");
        }
        GrIfStatement parentStatement = (GrIfStatement)element;
        assert (parentStatement != null);
        GrStatement elseBranch = parentStatement.getElseBranch();
        IntentionUtils.replaceStatement("if(" + parentStatement.getCondition().getText() + ")" + parentStatement.getThenBranch().getText() + "else{\n" + elseBranch.getText() + "\n}", parentStatement);
    }
}

