/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class ConvertMethodToClosureIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MyPredicate myPredicate = new MyPredicate();
        if (myPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/conversions/ConvertMethodToClosureIntention.getElementPredicate must not return null");
        }
        return myPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/conversions/ConvertMethodToClosureIntention.processIntention must not be null");
        }
        element = element.getParent();
        GrMethod method = (GrMethod)element;
        StringBuilder builder = new StringBuilder(method.getTextLength());
        String modifiers = method.getModifierList().getText();
        if (modifiers.trim().length() == 0) {
            modifiers = "def";
        }
        builder.append(modifiers).append(' ');
        builder.append(method.getName()).append("={");
        builder.append(method.getParameterList().getText()).append(" ->");
        GrOpenBlock block = method.getBlock();
        builder.append(block.getText().substring(1));
        GrVariableDeclaration variableDeclaration = GroovyPsiElementFactory.getInstance(element.getProject()).createFieldDeclarationFromText(builder.toString());
        method.replace(variableDeclaration);
    }

    private static class MyPredicate
    implements PsiElementPredicate {
        private MyPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            PsiElement parent = element.getParent();
            return parent instanceof GrMethod && element == ((GrMethod)parent).getNameIdentifierGroovy() && ((GrMethod)parent).getBlock() != null && parent.getParent() instanceof GrTypeDefinitionBody;
        }
    }
}

