/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GroovyDocPsiElement;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;

public abstract class GrDocCommentUtil {
    @Nullable
    public static GrDocCommentOwner findDocOwner(GroovyDocPsiElement docElement) {
        ASTNode node;
        GroovyDocPsiElement element;
        for (element = docElement; element != null && element.getParent() instanceof GroovyDocPsiElement; element = element.getParent()) {
        }
        if (element == null) {
            return null;
        }
        do {
            if ((element = element.getNextSibling()) == null) {
                return null;
            }
            node = element.getNode();
            if (node != null) continue;
            return null;
        } while (!GroovyElementTypes.GROOVY_DOC_COMMENT.equals(node.getElementType()) && GroovyElementTypes.WHITE_SPACES_OR_COMMENTS.contains(node.getElementType()));
        if (element instanceof GrDocCommentOwner) {
            return (GrDocCommentOwner)((Object)element);
        }
        return null;
    }

    @Nullable
    public static GrDocComment findDocComment(GrDocCommentOwner owner) {
        PsiElement element = owner.getPrevSibling();
        while (true) {
            if (element == null) {
                return null;
            }
            ASTNode node = element.getNode();
            if (node == null) {
                return null;
            }
            if (GroovyElementTypes.GROOVY_DOC_COMMENT.equals(node.getElementType()) || !GroovyElementTypes.WHITE_SPACES_OR_COMMENTS.contains(node.getElementType())) break;
            element = element.getPrevSibling();
        }
        if (element instanceof GrDocComment) {
            return (GrDocComment)element;
        }
        return null;
    }
}

