/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.parameters;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.VariableInitializer;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations.Annotation;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeSpec;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class ParameterDeclaration
implements GroovyElementTypes {
    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker pdMarker = builder.mark();
        ParameterDeclaration.parseOptionalModifier(builder, parser);
        PsiBuilder.Marker rb = builder.mark();
        TypeSpec.parseStrict(builder);
        if (!mIDENT.equals(builder.getTokenType()) && !mTRIPLE_DOT.equals(builder.getTokenType())) {
            rb.rollbackTo();
        } else {
            rb.drop();
        }
        boolean hasDots = ParserUtils.getToken(builder, mTRIPLE_DOT);
        if (ParserUtils.getToken(builder, mIDENT)) {
            if (mASSIGN.equals(builder.getTokenType())) {
                VariableInitializer.parse(builder, parser);
            }
            pdMarker.done((IElementType)PARAMETER);
            return true;
        }
        if (hasDots) {
            pdMarker.error(GroovyBundle.message("identifier.expected", new Object[0]));
            return true;
        }
        pdMarker.rollbackTo();
        return false;
    }

    private static void parseOptionalModifier(PsiBuilder builder, GroovyParser parser) {
        HashSet<IElementType> modSet = new HashSet<IElementType>();
        PsiBuilder.Marker marker = builder.mark();
        while (builder.getTokenType() == kFINAL || builder.getTokenType() == kDEF || builder.getTokenType() == mAT) {
            if (kFINAL.equals(builder.getTokenType())) {
                if (modSet.contains(kFINAL)) {
                    ParserUtils.wrapError(builder, GroovyBundle.message("duplicate.modifier", "final"));
                } else {
                    builder.advanceLexer();
                    modSet.add(kFINAL);
                }
                ParserUtils.getToken(builder, mNLS);
                continue;
            }
            if (kDEF.equals(builder.getTokenType())) {
                if (modSet.contains(kDEF)) {
                    ParserUtils.wrapError(builder, GroovyBundle.message("duplicate.modifier", "def"));
                } else {
                    builder.advanceLexer();
                    modSet.add(kDEF);
                }
                ParserUtils.getToken(builder, mNLS);
                continue;
            }
            if (!Annotation.parse(builder, parser)) continue;
            ParserUtils.getToken(builder, mNLS);
        }
        marker.done((IElementType)MODIFIERS);
    }
}

