/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.toplevel.imports;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.AccessorResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class GrImportStatementImpl
extends GroovyPsiElementImpl
implements GrImportStatement {
    public GrImportStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitImportStatement(this);
    }

    public String toString() {
        return "Import statement";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl.processDeclarations must not be null");
        }
        if (PsiTreeUtil.isAncestor((PsiElement)this, (PsiElement)place, (boolean)false)) {
            return true;
        }
        if (processor instanceof ResolverProcessor) {
            ((ResolverProcessor)processor).setCurrentFileResolveContext(this);
        }
        try {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
            if (this.isOnDemand()) {
                GrCodeReferenceElement ref = this.getImportReference();
                if (ref != null) {
                    if (this.isStatic()) {
                        PsiClass clazz;
                        PsiElement resolved = ref.resolve();
                        if (resolved instanceof PsiClass && (clazz = (PsiClass)resolved) != null && !GrImportStatementImpl.processAllMembers(processor, clazz)) {
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        PsiPackage aPackage;
                        String qName = PsiUtil.getQualifiedReferenceText(ref);
                        if (qName != null && (aPackage = facade.findPackage(qName)) != null && !aPackage.processDeclarations(processor, state, lastParent, place)) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
            } else {
                String name = this.getImportedName();
                if (name != null) {
                    String qName;
                    NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
                    GrCodeReferenceElement ref = this.getImportReference();
                    if (ref != null && (qName = ref.getCanonicalText()) != null && qName.indexOf(46) > 0) {
                        if (!this.isStatic()) {
                            if (nameHint == null || name.equals(nameHint.getName(state))) {
                                PsiClass clazz = facade.findClass(qName, this.getResolveScope());
                                if (clazz != null && !processor.execute((PsiElement)clazz, state)) {
                                    boolean bl = false;
                                    return bl;
                                }
                            }
                        } else {
                            String classQName;
                            PsiClass clazz;
                            int i = qName.lastIndexOf(46);
                            if (i > 0 && (clazz = facade.findClass(classQName = qName.substring(0, i), this.getResolveScope())) != null) {
                                String refName = ref.getReferenceName();
                                if (nameHint == null || name.equals(nameHint.getName(state))) {
                                    PsiField field = clazz.findFieldByName(refName, false);
                                    if (field != null && field.hasModifierProperty("static") && !processor.execute((PsiElement)field, state)) {
                                        boolean bl = false;
                                        return bl;
                                    }
                                    for (PsiMethod method : clazz.findMethodsByName(refName, false)) {
                                        if (!method.hasModifierProperty("static") || processor.execute((PsiElement)method, state)) continue;
                                        boolean bl = false;
                                        return bl;
                                    }
                                }
                                if (processor instanceof AccessorResolverProcessor) {
                                    PsiMethod setter;
                                    PsiMethod getter = GroovyPropertyUtils.findPropertyGetter(clazz, refName, true, true);
                                    if (getter != null && (nameHint == null || GroovyPropertyUtils.getPropertyNameByGetterName(nameHint.getName(state), true).equals(name))) {
                                        processor.execute((PsiElement)getter, state);
                                    }
                                    if ((setter = GroovyPropertyUtils.findPropertySetter(clazz, refName, true, true)) != null && (nameHint == null || GroovyPropertyUtils.getPropertyNameBySetterName(nameHint.getName(state)).equals(name))) {
                                        processor.execute((PsiElement)setter, state);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (processor instanceof ResolverProcessor) {
                ((ResolverProcessor)processor).setCurrentFileResolveContext(null);
            }
        }
    }

    private static boolean processAllMembers(PsiScopeProcessor processor, PsiClass clazz) {
        for (PsiField psiField : clazz.getFields()) {
            if (!psiField.hasModifierProperty("static") || ResolveUtil.processElement(processor, (PsiNamedElement)psiField)) continue;
            return false;
        }
        for (PsiField psiField : clazz.getMethods()) {
            if (!psiField.hasModifierProperty("static") || ResolveUtil.processElement(processor, (PsiNamedElement)psiField)) continue;
            return false;
        }
        return true;
    }

    @Override
    public GrCodeReferenceElement getImportReference() {
        return (GrCodeReferenceElement)this.findChildByClass(GrCodeReferenceElement.class);
    }

    @Override
    @Nullable
    public String getImportedName() {
        if (this.isOnDemand()) {
            return null;
        }
        PsiElement identifier = this.findChildByType(GroovyTokenTypes.mIDENT);
        if (identifier != null) {
            return identifier.getText();
        }
        GrCodeReferenceElement ref = (GrCodeReferenceElement)this.findChildByClass(GrCodeReferenceElement.class);
        return ref == null ? null : ref.getReferenceName();
    }

    @Override
    public boolean isStatic() {
        return this.findChildByType(GroovyTokenTypes.kSTATIC) != null;
    }

    @Override
    public boolean isAliasedImport() {
        return this.findChildByType(GroovyTokenTypes.mIDENT) != null;
    }

    @Override
    public boolean isOnDemand() {
        return this.findChildByType(GroovyTokenTypes.mSTAR) != null;
    }

    @Override
    public GrModifierList getAnnotationList() {
        return (GrModifierList)this.findChildByClass(GrModifierList.class);
    }
}

