/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.InjectionsSettingsUI;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SettingsUI {
    private Configurable[] myConfigurables;
    private final JPanel myRoot;
    private final JTabbedPane myTabbedPane;

    SettingsUI(@NotNull Project project, Configuration configuration) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/SettingsUI.<init> must not be null");
        }
        this.myRoot = new JPanel(new BorderLayout());
        this.myTabbedPane = new JTabbedPane(1);
        this.myRoot.add(this.myTabbedPane);
        ArrayList<Configurable> configurables = new ArrayList<Configurable>();
        for (LanguageInjectionSupport support : (LanguageInjectionSupport[])Extensions.getExtensions(LanguageInjectionSupport.EP_NAME)) {
            configurables.addAll(Arrays.asList(support.createSettings(project, configuration)));
        }
        Collections.sort(configurables, new Comparator<Configurable>(){

            @Override
            public int compare(Configurable o1, Configurable o2) {
                return Comparing.compare((Comparable)((Object)o1.getDisplayName()), (Comparable)((Object)o2.getDisplayName()));
            }
        });
        configurables.add(0, new InjectionsSettingsUI(project, configuration));
        this.myConfigurables = configurables.toArray(new Configurable[configurables.size()]);
        for (Configurable configurable : configurables) {
            this.myTabbedPane.addTab(configurable.getDisplayName(), configurable.createComponent());
        }
    }

    public JComponent createComponent() {
        return this.myRoot;
    }

    @Nullable
    public Configurable getSelectedChild() {
        int index = this.myTabbedPane.getSelectedIndex();
        if (index >= 0) {
            return this.myConfigurables[index];
        }
        return null;
    }

    public boolean isModified() {
        for (Configurable configurable : this.myConfigurables) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (Configurable configurable : this.myConfigurables) {
            configurable.apply();
        }
    }

    public void reset() {
        for (Configurable configurable : this.myConfigurables) {
            configurable.reset();
        }
    }
}

