/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.groovy;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.scope.PsiScopeProcessor;
import org.intellij.plugins.intelliLang.PatternBasedInjectionHelper;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class PatternEditorContextMembersProvider
implements NonCodeMembersProcessor {
    public static final Key<AtomicNotNullLazyValue<PsiFile>> INJECTION_PARSED_CONTEXT = Key.create((String)"INJECTION_PARSED_CONTEXT");

    public boolean processNonCodeMembers(PsiType type, PsiScopeProcessor processor, PsiElement place, boolean forCompletion) {
        final PsiFile file = place.getContainingFile().getOriginalFile();
        final BaseInjection injection = (BaseInjection)file.getUserData(BaseInjection.INJECTION_KEY);
        if (injection == null) {
            return true;
        }
        PsiFile contextFile = (PsiFile)((AtomicNotNullLazyValue)((UserDataHolderEx)file).putUserDataIfAbsent(INJECTION_PARSED_CONTEXT, (Object)new AtomicNotNullLazyValue<PsiFile>(){

            @NotNull
            protected PsiFile compute() {
                PsiFile psiFile = PatternEditorContextMembersProvider.parseInjectionContext(injection, file.getProject());
                if (psiFile == null) {
                    throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/groovy/PatternEditorContextMembersProvider$1.compute must not return null");
                }
                return psiFile;
            }
        })).getValue();
        for (PsiElement cur = contextFile.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof PsiNamedElement) || ResolveUtil.processElement((PsiScopeProcessor)processor, (PsiNamedElement)((PsiNamedElement)cur))) continue;
            return false;
        }
        return true;
    }

    private static PsiFile parseInjectionContext(@NotNull BaseInjection injection, Project project) {
        if (injection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/groovy/PatternEditorContextMembersProvider.parseInjectionContext must not be null");
        }
        String text = PatternBasedInjectionHelper.dumpContextDeclarations(injection.getSupportId());
        return PsiFileFactory.getInstance((Project)project).createFileFromText("context.groovy", (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)text);
    }
}

