/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.Profile;
import com.intellij.util.Icons;
import com.intellij.util.containers.HashMap;
import com.maddyhome.idea.copyright.CopyrightManager;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.options.ExternalOptionHelper;
import com.maddyhome.idea.copyright.ui.CopyrightConfigurable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyrightProfilesPanel
extends MasterDetailsComponent
implements SearchableConfigurable {
    private static final Icon COPY_ICON = IconLoader.getIcon((String)"/actions/copy.png");
    private final Project myProject;
    private final CopyrightManager myManager;
    private final AtomicBoolean myInitialized = new AtomicBoolean(false);

    public CopyrightProfilesPanel(Project project) {
        MasterDetailsStateService.getInstance((Project)project).register("Copyright.UI", (MasterDetailsComponent)this);
        this.myProject = project;
        this.myManager = CopyrightManager.getInstance(project);
        this.initTree();
    }

    protected void processRemovedItems() {
        Map<String, CopyrightProfile> profiles = this.getAllProfiles();
        ArrayList<CopyrightProfile> deleted = new ArrayList<CopyrightProfile>();
        for (CopyrightProfile profile : this.myManager.getCopyrights()) {
            if (profiles.containsValue((Object)profile)) continue;
            deleted.add(profile);
        }
        for (CopyrightProfile profile : deleted) {
            this.myManager.removeCopyright(profile);
        }
    }

    protected boolean wasObjectStored(Object o) {
        return this.myManager.getCopyrights().contains((Object)((CopyrightProfile)((Object)o)));
    }

    @Nls
    public String getDisplayName() {
        return "Copyright Profiles";
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "copyright.profiles";
    }

    public void apply() throws ConfigurationException {
        HashSet<String> profiles = new HashSet<String>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            String profileName = ((CopyrightConfigurable)node.getConfigurable()).getEditableObject().getName();
            if (profiles.contains(profileName)) {
                this.selectNodeInTree(profileName);
                throw new ConfigurationException("Duplicate copyright profile name: '" + profileName + "'");
            }
            profiles.add(profileName);
        }
        super.apply();
    }

    public Map<String, CopyrightProfile> getAllProfiles() {
        HashMap profiles = new HashMap();
        if (!this.myInitialized.get()) {
            for (CopyrightProfile profile : this.myManager.getCopyrights()) {
                profiles.put(profile.getName(), profile);
            }
        } else {
            for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
                MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
                CopyrightProfile copyrightProfile = ((CopyrightConfigurable)node.getConfigurable()).getEditableObject();
                profiles.put(copyrightProfile.getName(), copyrightProfile);
            }
        }
        return profiles;
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        this.myInitialized.set(false);
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add(new AnAction("Add", "Add", Icons.ADD_ICON){
            {
                this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)CopyrightProfilesPanel.this.myTree);
            }

            public void actionPerformed(AnActionEvent event) {
                String name = CopyrightProfilesPanel.this.askForProfileName("Create new copyright profile", "");
                if (name == null) {
                    return;
                }
                CopyrightProfile copyrightProfile = new CopyrightProfile(name);
                CopyrightProfilesPanel.this.addProfileNode(copyrightProfile);
            }
        });
        result.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this, Conditions.alwaysTrue()));
        result.add(new AnAction("Copy", "Copy", COPY_ICON){
            {
                this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(68, 2)), (JComponent)CopyrightProfilesPanel.this.myTree);
            }

            public void actionPerformed(AnActionEvent event) {
                String profileName = CopyrightProfilesPanel.this.askForProfileName("Copy copyright profile", "");
                if (profileName == null) {
                    return;
                }
                CopyrightProfile clone = new CopyrightProfile();
                clone.copyFrom((Profile)((CopyrightProfile)((Object)CopyrightProfilesPanel.this.getSelectedObject())));
                clone.setName(profileName);
                CopyrightProfilesPanel.this.addProfileNode(clone);
            }

            public void update(AnActionEvent event) {
                super.update(event);
                event.getPresentation().setEnabled(CopyrightProfilesPanel.this.getSelectedObject() != null);
            }
        });
        result.add(new AnAction("Import", "Import", Icons.ADVICE_ICON){

            public void actionPerformed(AnActionEvent event) {
                OpenProjectFileChooserDescriptor descriptor = new OpenProjectFileChooserDescriptor(true){

                    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                        return super.isFileVisible(file, showHiddenFiles) || this.canContainCopyright(file);
                    }

                    public boolean isFileSelectable(VirtualFile file) {
                        return super.isFileSelectable(file) || this.canContainCopyright(file);
                    }

                    private boolean canContainCopyright(VirtualFile file) {
                        return !file.isDirectory() && (file.getFileType() == StdFileTypes.IDEA_MODULE || file.getFileType() == StdFileTypes.XML);
                    }
                };
                descriptor.setTitle("Choose file containing copyright notice");
                VirtualFile[] files = FileChooser.chooseFiles((Project)CopyrightProfilesPanel.this.myProject, (FileChooserDescriptor)descriptor);
                if (files.length != 1) {
                    return;
                }
                List<CopyrightProfile> copyrightProfiles = ExternalOptionHelper.loadOptions(VfsUtil.virtualToIoFile((VirtualFile)files[0]));
                if (copyrightProfiles != null) {
                    if (copyrightProfiles.size() == 1) {
                        this.importProfile(copyrightProfiles.get(0));
                    } else {
                        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<CopyrightProfile>("Choose profile to import", copyrightProfiles){

                            public PopupStep onChosen(final CopyrightProfile selectedValue, boolean finalChoice) {
                                return this.doFinalStep(new Runnable(){

                                    @Override
                                    public void run() {
                                        this.importProfile(selectedValue);
                                    }
                                });
                            }

                            @NotNull
                            public String getTextFor(CopyrightProfile value) {
                                String string = value.getName();
                                if (string == null) {
                                    throw new IllegalStateException("@NotNull method com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel$3$2.getTextFor must not return null");
                                }
                                return string;
                            }
                        }).showUnderneathOf((Component)CopyrightProfilesPanel.this.myNorthPanel);
                    }
                } else {
                    Messages.showWarningDialog((Project)CopyrightProfilesPanel.this.myProject, (String)"The selected file did not contain any copyright settings.", (String)"Import Failure");
                }
            }

            private void importProfile(CopyrightProfile copyrightProfile) {
                String profileName = CopyrightProfilesPanel.this.askForProfileName("Import copyright profile", copyrightProfile.getName());
                if (profileName == null) {
                    return;
                }
                copyrightProfile.setName(profileName);
                CopyrightProfilesPanel.this.addProfileNode(copyrightProfile);
                Messages.showInfoMessage((Project)CopyrightProfilesPanel.this.myProject, (String)"The copyright settings have been successfully imported.", (String)"Import Complete");
            }
        });
        return result;
    }

    @Nullable
    private String askForProfileName(String title, String initialName) {
        return Messages.showInputDialog((String)"New copyright profile name:", (String)title, (Icon)Messages.getQuestionIcon(), (String)initialName, (InputValidator)new InputValidator(){

            public boolean checkInput(String s) {
                return !CopyrightProfilesPanel.this.getAllProfiles().containsKey(s) && s.length() > 0;
            }

            public boolean canClose(String s) {
                return this.checkInput(s);
            }
        });
    }

    private void addProfileNode(CopyrightProfile copyrightProfile) {
        CopyrightConfigurable copyrightConfigurable = new CopyrightConfigurable(this.myProject, copyrightProfile, this.TREE_UPDATER);
        copyrightConfigurable.setModified(true);
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)copyrightConfigurable);
        this.addNode(node, this.myRoot);
        this.selectNodeInTree((DefaultMutableTreeNode)node);
    }

    private void reloadTree() {
        this.myRoot.removeAllChildren();
        Collection<CopyrightProfile> collection = this.myManager.getCopyrights();
        for (CopyrightProfile profile : collection) {
            CopyrightProfile clone = new CopyrightProfile();
            clone.copyFrom((Profile)profile);
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)new CopyrightConfigurable(this.myProject, clone, this.TREE_UPDATER)), this.myRoot);
        }
        this.myInitialized.set(true);
    }

    public void reset() {
        this.reloadTree();
        super.reset();
    }

    protected String getEmptySelectionString() {
        return "Select a profile to view or edit its details here";
    }

    public void addItemsChangeListener(final Runnable runnable) {
        this.addItemsChangeListener(new MasterDetailsComponent.ItemsChangeListener(){

            public void itemChanged(@Nullable Object deletedItem) {
                SwingUtilities.invokeLater(runnable);
            }

            public void itemsExternallyChanged() {
                SwingUtilities.invokeLater(runnable);
            }
        });
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }
}

