/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.ui;

import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestNGConsoleProperties;
import com.theoryinpractice.testng.model.TestProxy;
import com.theoryinpractice.testng.ui.Printable;
import com.theoryinpractice.testng.ui.TestNGDiffHyperLink;
import com.theoryinpractice.testng.ui.TestNGResults;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.testng.remote.strprotocol.TestResultMessage;

public class TestNGConsoleView
extends BaseTestsOutputConsoleView {
    @NonNls
    private static final Pattern COMPARISION_PATTERN = Pattern.compile("([^\\<\\>]*)expected[^\\<\\>]*\\<([^\\<\\>]*)\\>[^\\<\\>]*\\<([^\\<\\>]*)\\>[^\\<\\>]*");
    @NonNls
    private static final Pattern EXPECTED_BUT_WAS_PATTERN = Pattern.compile("(.*)expected:\\<(.*)\\> but was:\\<(.*)\\>.*", 32);
    @NonNls
    private static final Pattern EXPECTED_NOT_SAME_BUT_WAS_PATTERN = Pattern.compile("(.*)expected not same with:\\<(.*)\\> but was:\\<(.*)\\>.*", 32);
    private TestNGResults testNGResults;
    private final List<Printable> currentTestOutput = new ArrayList<Printable>();
    private final List<Printable> nonTestOutput = new ArrayList<Printable>();
    private int myExceptionalMark = -1;
    private final TestNGConfiguration myConfiguration;
    private final RunnerSettings myRunnerSettings;
    private final ConfigurationPerRunnerSettings myConfigurationPerRunnerSettings;

    public TestNGConsoleView(TestNGConfiguration config, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationPerRunnerSettings) {
        super((TestConsoleProperties)new TestNGConsoleProperties(config));
        this.myConfiguration = config;
        this.myRunnerSettings = runnerSettings;
        this.myConfigurationPerRunnerSettings = configurationPerRunnerSettings;
    }

    protected TestResultsPanel createTestResultsPanel() {
        this.testNGResults = new TestNGResults(this.getConsole().getComponent(), this.myConfiguration, this, this.myRunnerSettings, this.myConfigurationPerRunnerSettings);
        return this.testNGResults;
    }

    public void dispose() {
        super.dispose();
        this.testNGResults = null;
    }

    public TestNGResults getResultsView() {
        return this.testNGResults;
    }

    public void rebuildTree() {
        if (this.testNGResults != null) {
            this.testNGResults.rebuildTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTestResult(TestResultMessage result) {
        if (this.testNGResults != null) {
            if (!this.testNGResults.wasTestStarted(result)) {
                this.flushOutput();
            }
            int exceptionMark = this.myExceptionalMark == -1 ? 0 : this.myExceptionalMark;
            String stackTrace = result.getStackTrace();
            if (stackTrace != null && stackTrace.length() > 10) {
                String trimmed = TestNGConsoleView.trimStackTrace(stackTrace);
                List<Printable> printables = this.getPrintables(result, trimmed);
                for (Printable printable : printables) {
                    printable.print(this.getConsole());
                }
                List<Printable> list = this.currentTestOutput;
                synchronized (list) {
                    exceptionMark = this.currentTestOutput.size();
                    this.currentTestOutput.addAll(printables);
                }
            }
            this.testNGResults.addTestResult(result, new ArrayList<Printable>(this.currentTestOutput), exceptionMark);
            this.myExceptionalMark = -1;
            List<Printable> list = this.currentTestOutput;
            synchronized (list) {
                this.currentTestOutput.clear();
            }
        }
    }

    public void testStarted(TestResultMessage result) {
        if (this.testNGResults != null) {
            this.flushOutput();
            this.testNGResults.testStarted(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushOutput() {
        List<Printable> list = this.currentTestOutput;
        synchronized (list) {
            if (!this.currentTestOutput.isEmpty()) {
                this.nonTestOutput.addAll(this.currentTestOutput);
                this.currentTestOutput.clear();
            }
        }
    }

    public void flush() {
        List<Printable> output;
        TestProxy failedToStart = this.testNGResults.getFailedToStart();
        if (failedToStart != null && (output = failedToStart.getOutput()) != null) {
            this.nonTestOutput.addAll(output);
        }
    }

    private static String trimStackTrace(String stackTrace) {
        String[] lines = stackTrace.split("\n");
        StringBuilder builder = new StringBuilder();
        if (lines.length > 0) {
            int i;
            for (i = lines.length - 1; i >= 0; --i) {
                int startIndex = lines[i].indexOf(97) + 3;
                if (lines[i].length() <= 4 || !lines[i].startsWith("org.testng.", startIndex) && !lines[i].startsWith("org.junit.", startIndex) && !lines[i].startsWith("sun.reflect.DelegatingMethodAccessorImpl", startIndex) && !lines[i].startsWith("sun.reflect.NativeMethodAccessorImpl", startIndex) && !lines[i].startsWith("java.lang.reflect.Method", startIndex) && !lines[i].startsWith("com.intellij.rt.execution.application.AppMain", startIndex)) break;
            }
            for (int j = 0; j <= i; ++j) {
                builder.append(lines[j]);
                builder.append('\n');
            }
        }
        return builder.toString();
    }

    private List<Printable> getPrintables(final TestResultMessage result, String s) {
        ArrayList<Printable> printables = new ArrayList<Printable>();
        Matcher matcher = COMPARISION_PATTERN.matcher(s);
        if (!matcher.matches()) {
            matcher = EXPECTED_BUT_WAS_PATTERN.matcher(s);
        }
        if (!matcher.matches()) {
            matcher = EXPECTED_NOT_SAME_BUT_WAS_PATTERN.matcher(s);
        }
        if (matcher.matches()) {
            printables.add(new Chunk(matcher.group(1), ConsoleViewContentType.ERROR_OUTPUT));
            TestNGDiffHyperLink link = new TestNGDiffHyperLink(matcher.group(2), matcher.group(3), null, (TestNGConsoleProperties)this.myProperties){

                protected String getTitle() {
                    return result.getTestClass() + '#' + result.getMethod() + "() failed";
                }
            };
            printables.add(link);
            printables.add(new Chunk(TestNGConsoleView.trimStackTrace(s.substring(matcher.end(3) + 1)), ConsoleViewContentType.ERROR_OUTPUT));
        } else {
            printables.add(new Chunk(s, ConsoleViewContentType.ERROR_OUTPUT));
        }
        return printables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String s, ConsoleViewContentType contentType) {
        if (this.myExceptionalMark == -1 && contentType == ConsoleViewContentType.ERROR_OUTPUT) {
            this.myExceptionalMark = this.currentTestOutput.size();
        }
        Chunk chunk = new Chunk(s, contentType);
        List<Printable> list = this.currentTestOutput;
        synchronized (list) {
            this.currentTestOutput.add(chunk);
        }
    }

    public void reset() {
        ArrayList<Printable> printables = new ArrayList<Printable>();
        printables.addAll(this.nonTestOutput);
        printables.addAll(this.testNGResults.getRoot().getOutput());
        printables.addAll(this.currentTestOutput);
        this.setView(printables, 0);
    }

    public void attachToProcess(ProcessHandler processHandler) {
        this.getConsole().attachToProcess(processHandler);
    }

    public void setView(final List<Printable> output, final int i) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TestNGConsoleView.this.setView(output, i);
                }
            });
        } else {
            this.getConsole().clear();
            int idx = 0;
            int offset = 0;
            for (Printable chunk : new ArrayList<Printable>(output)) {
                chunk.print(this.getConsole());
                if (idx++ >= i) continue;
                offset = this.getConsole().getContentSize();
            }
            this.getConsole().scrollTo(offset);
        }
    }

    public static class Chunk
    implements Printable {
        public String text;
        public ConsoleViewContentType contentType;

        @Override
        public void print(ConsoleView console) {
            console.print(this.text, this.contentType);
        }

        public Chunk(String text, ConsoleViewContentType contentType) {
            this.text = text;
            this.contentType = contentType;
        }

        public String toString() {
            return this.text;
        }
    }
}

