/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config;

import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ExtConfiguration;
import com.intellij.cvsSupport2.config.LocalSettings;
import com.intellij.cvsSupport2.config.ProxySettings;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.RoamingTypeDisabled;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CvsApplicationLevelConfiguration
implements ApplicationComponent,
JDOMExternalizable,
RoamingTypeDisabled {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration");
    public List<CvsRootConfiguration> CONFIGURATIONS = new ArrayList<CvsRootConfiguration>();
    public ExtConfiguration EXT_CONFIGURATION = new ExtConfiguration();
    public SshSettings SSH_CONFIGURATION = new SshSettings();
    public LocalSettings LOCAL_CONFIGURATION = new LocalSettings();
    public ProxySettings PROXY_SETTINGS = new ProxySettings();
    public SshSettings SSH_FOR_EXT_CONFIGURATION = new SshSettings();
    @NonNls
    private static final String CONFIGURATION_ELEMENT_NAME = "Configuration";
    public String PATH_TO_PASSWORD_FILE = null;
    public int TIMEOUT = 60;
    public boolean MAKE_CHECKED_OUT_FILES_READONLY = false;
    public boolean CHECKOUT_PRUNE_EMPTY_DIRECTORIES = true;
    public String CHECKOUT_KEYWORD_SUBSTITUTION = null;
    public boolean SHOW_RESTORE_DIRECTORIES_CONFIRMATION = true;
    @NotNull
    public String ENCODING = "Default";
    public boolean USE_GZIP = false;
    @NonNls
    public static final String DEFAULT = "Default";
    public boolean DO_OUTPUT = false;
    @NonNls
    private static final String USER_HOME_PROPERTY = "user.home";
    public boolean SEND_ENVIRONMENT_VARIABLES_TO_SERVER = false;

    public static CvsApplicationLevelConfiguration getInstance() {
        return (CvsApplicationLevelConfiguration)ServiceManager.getService(CvsApplicationLevelConfiguration.class);
    }

    public String getComponentName() {
        return "CvsApplicationLevelConfiguration";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        for (Element child : element.getChildren(CONFIGURATION_ELEMENT_NAME)) {
            this.CONFIGURATIONS.add(this.createConfigurationOn(child));
        }
        if (!this.encodingExists(this.ENCODING)) {
            this.ENCODING = DEFAULT;
        }
        this.updateConfigurations();
    }

    private boolean encodingExists(String encoding) {
        Charset[] availableCharsets = CharsetToolkit.getAvailableCharsets();
        for (int i = 0; i < availableCharsets.length; ++i) {
            Charset availableCharset = availableCharsets[i];
            if (!availableCharset.name().equals(encoding)) continue;
            return true;
        }
        return false;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        Iterator<CvsRootConfiguration> each = this.CONFIGURATIONS.iterator();
        while (each.hasNext()) {
            this.createConfigurationElement(each.next(), element);
        }
    }

    private void createConfigurationElement(CvsRootConfiguration configuration, Element element) throws WriteExternalException {
        Element child = new Element(CONFIGURATION_ELEMENT_NAME);
        configuration.writeExternal(child);
        element.addContent(child);
    }

    private CvsRootConfiguration createConfigurationOn(Element child) throws InvalidDataException {
        CvsRootConfiguration config = CvsApplicationLevelConfiguration.createNewConfiguration(this);
        config.readExternal(child);
        return config;
    }

    @NonNls
    private String defaultPathToPassFile() {
        return "$userdir/.cvspass";
    }

    private boolean passFileExists() {
        if (this.PATH_TO_PASSWORD_FILE == null) {
            return false;
        }
        return new File(CvsApplicationLevelConfiguration.convertToIOFilePath(this.PATH_TO_PASSWORD_FILE)).isFile();
    }

    public static String convertToIOFilePath(String presentation) {
        String userHome = System.getProperty(USER_HOME_PROPERTY);
        userHome = userHome.replace(File.separatorChar, '/');
        presentation = presentation.replace(File.separatorChar, '/');
        try {
            String result = StringUtil.replace((String)presentation, (String)"$userdir", (String)userHome);
            result = result.replace('/', File.separatorChar);
            return result;
        }
        catch (Exception ex) {
            LOG.error("userHome = " + userHome + ", presenation = " + presentation);
            return "";
        }
    }

    public String getPathToPassFile() {
        return CvsApplicationLevelConfiguration.convertToIOFilePath(this.getPathToPassFilePresentation());
    }

    public String getPathToPassFilePresentation() {
        if (!this.passFileExists()) {
            this.PATH_TO_PASSWORD_FILE = this.defaultPathToPassFile();
        }
        return this.PATH_TO_PASSWORD_FILE;
    }

    public CvsRootConfiguration getConfigurationForCvsRoot(String root) {
        for (CvsRootConfiguration cvsRootConfiguration : this.CONFIGURATIONS) {
            if (!cvsRootConfiguration.getCvsRootAsString().equals(root)) continue;
            return cvsRootConfiguration;
        }
        CvsRootConfiguration newConfig = CvsApplicationLevelConfiguration.createNewConfiguration(this);
        newConfig.CVS_ROOT = root;
        this.CONFIGURATIONS.add(newConfig);
        return newConfig;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getCharset() {
        String string;
        String value = CvsApplicationLevelConfiguration.getInstance().ENCODING;
        if (DEFAULT.equals(value)) {
            string = CharsetToolkit.getDefaultSystemCharset().name();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/config/CvsApplicationLevelConfiguration.getCharset must not return null");
            return string;
        }
        string = value;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/config/CvsApplicationLevelConfiguration.getCharset must not return null");
    }

    public void setPathToPasswordFile(String text) {
        this.PATH_TO_PASSWORD_FILE = text;
        this.updateConfigurations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfigurations() {
        File passFile = new File(this.getPathToPassFile());
        if (passFile.isFile()) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(passFile)));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int sepPosition = line.indexOf(32);
                        if (sepPosition <= 0) continue;
                        String cvsRoot = line.substring(0, sepPosition);
                        this.tryToAddNewRoot(cvsRoot);
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void tryToAddNewRoot(String cvsRoot) {
        for (CvsRootConfiguration configuration : this.CONFIGURATIONS) {
            if (!Comparing.equal((String)configuration.getCvsRootAsString(), (String)cvsRoot)) continue;
            return;
        }
        CvsRootConfiguration newConfiguration = CvsApplicationLevelConfiguration.createNewConfiguration(this);
        newConfiguration.CVS_ROOT = cvsRoot;
        this.CONFIGURATIONS.add(newConfiguration);
    }

    public static CvsRootConfiguration createNewConfiguration(CvsApplicationLevelConfiguration mainConfiguration) {
        CvsRootConfiguration result = new CvsRootConfiguration();
        result.EXT_CONFIGURATION = mainConfiguration.EXT_CONFIGURATION.clone();
        result.SSH_CONFIGURATION = mainConfiguration.SSH_CONFIGURATION.clone();
        result.SSH_FOR_EXT_CONFIGURATION = mainConfiguration.SSH_FOR_EXT_CONFIGURATION.clone();
        result.LOCAL_CONFIGURATION = mainConfiguration.LOCAL_CONFIGURATION.clone();
        result.PROXY_SETTINGS = mainConfiguration.PROXY_SETTINGS.clone();
        return result;
    }
}

