/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config.ui;

import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.connections.pserver.ui.PServerSettingsPanel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GlobalCvsSettingsPanel {
    private final PServerSettingsPanel myPServerSettingsPanel;
    private JComponent myPanel;
    private JPanel myPServerPanel;
    private JCheckBox myUseGZIPCompression;
    private JComboBox myCharset;
    private JCheckBox myLogOutput;
    private JCheckBox mySendEnvironment;

    public GlobalCvsSettingsPanel() {
        this.$$$setupUI$$$();
        this.myPServerSettingsPanel = new PServerSettingsPanel();
        this.myPServerPanel.setLayout(new BorderLayout());
        this.myPServerPanel.add((Component)this.myPServerSettingsPanel.getPanel(), "Center");
        Charset[] availableCharsets = CharsetToolkit.getAvailableCharsets();
        this.myCharset.addItem("Default");
        for (Charset charset : availableCharsets) {
            this.myCharset.addItem(charset.name());
        }
    }

    public void updateFrom(CvsApplicationLevelConfiguration config) {
        this.myPServerSettingsPanel.updateFrom(config);
        this.myCharset.setSelectedItem(config.ENCODING);
        this.myUseGZIPCompression.setSelected(config.USE_GZIP);
        this.myLogOutput.setSelected(config.DO_OUTPUT);
        this.mySendEnvironment.setSelected(config.SEND_ENVIRONMENT_VARIABLES_TO_SERVER);
    }

    public void saveTo(CvsApplicationLevelConfiguration config) {
        this.myPServerSettingsPanel.saveTo(config);
        String oldEncoding = config.ENCODING;
        config.ENCODING = this.myCharset.getSelectedItem().toString();
        if (!Comparing.equal((String)oldEncoding, (String)config.ENCODING)) {
            CvsEntriesManager.getInstance().encodingChanged();
        }
        config.USE_GZIP = this.myUseGZIPCompression.isSelected();
        config.DO_OUTPUT = this.myLogOutput.isSelected();
        config.SEND_ENVIRONMENT_VARIABLES_TO_SERVER = this.mySendEnvironment.isSelected();
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JComboBox jComboBox;
        JCheckBox jCheckBox3;
        JPanel jPanel2 = new JPanel();
        this.myPanel = jPanel2;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseGZIPCompression = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("checkbox.global.settings.use.gzip.compression"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCharset = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.charset.combo.label"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPServerPanel = jPanel = new JPanel();
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLogOutput = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("checkbox.log.cvs.client.server.output"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySendEnvironment = jCheckBox = new JCheckBox();
        jCheckBox.setText("Send environment variables to server");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(5);
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

