/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvsExecution.ModalityContextImpl;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsLog.LogOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.BranchesProvider;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsProvider;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.ui.SelectTagDialog;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.containers.HashSet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.log.Revision;
import org.netbeans.lib.cvsclient.command.log.SymbolicName;

public class TagsHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsHelper");

    private TagsHelper() {
    }

    @Nullable
    public static String chooseBranch(TagsProvider tagsProvider, Project project, boolean forTemporaryConfiguration) {
        try {
            BranchesProvider branchesProvider = TagsHelper.getBranchesProvider(tagsProvider.getOperation(), project, forTemporaryConfiguration);
            return TagsHelper.chooseFrom(branchesProvider.getAllBranches(), branchesProvider.getAllRevisions());
        }
        catch (VcsException e1) {
            TagsHelper.showErrorMessage(e1);
            return null;
        }
    }

    @Nullable
    public static String chooseBranch(Collection<FilePath> files, Project project, boolean forTemporaryConfiguration) {
        try {
            return TagsHelper.chooseFrom(TagsHelper.collectAllBranches(files, project, forTemporaryConfiguration), new ArrayList<CvsRevisionNumber>());
        }
        catch (VcsException e1) {
            TagsHelper.showErrorMessage(e1);
            return null;
        }
    }

    public static void addChooseBranchAction(final TextFieldWithBrowseButton field, final Collection<FilePath> files, final Project project) {
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String branchName = TagsHelper.chooseBranch(files, project, false);
                if (branchName != null) {
                    field.setText(branchName);
                }
            }
        });
    }

    public static Collection<String> getAllBranches(List<LogInformation> log) {
        HashSet branches = new HashSet();
        for (LogInformation logInformation : log) {
            TagsHelper.collectBranches(logInformation, (HashSet<String>)branches);
        }
        return branches;
    }

    private static void collectBranches(LogInformation logInformation, HashSet<String> branches) {
        List allSymbolicNames = logInformation.getAllSymbolicNames();
        for (SymbolicName symbolicName : allSymbolicNames) {
            branches.add((Object)symbolicName.getName());
        }
    }

    private static void collectRevisions(LogInformation logInformation, ArrayList<CvsRevisionNumber> result) {
        for (Revision revision : logInformation.getRevisionList()) {
            result.add(new CvsRevisionNumber(revision.getNumber()));
        }
    }

    private static BranchesProvider getBranchesProvider(CvsOperation operation, Project project, boolean forTemporaryConfiguration) throws VcsException {
        LOG.assertTrue(operation instanceof BranchesProvider);
        CvsOperationExecutor executor = new CvsOperationExecutor(true, project, new ModalityContextImpl(ModalityState.defaultModalityState(), forTemporaryConfiguration));
        CommandCvsHandler handler = new CommandCvsHandler(CvsBundle.message((String)"load.tags.operation.name", (Object[])new Object[0]), operation, true){

            @Override
            public String getCancelButtonText() {
                return CvsBundle.message((String)"button.text.stop", (Object[])new Object[0]);
            }
        };
        executor.performActionSync(handler, CvsOperationExecutorCallback.EMPTY);
        CvsResult executionResult = executor.getResult();
        if (!executionResult.hasNoErrors()) {
            throw executionResult.composeError();
        }
        return (BranchesProvider)((Object)operation);
    }

    private static Collection<String> collectAllBranches(Collection<FilePath> files, Project project, boolean forTemporaryConfiguration) throws VcsException {
        ArrayList<String> result = new ArrayList<String>();
        if (files.isEmpty()) {
            return result;
        }
        return TagsHelper.getBranchesProvider(new LogOperation(files), project, forTemporaryConfiguration).getAllBranches();
    }

    private static void showErrorMessage(VcsException e1) {
        Messages.showErrorDialog((String)CvsBundle.message((String)"error.message.cannot.load.tags", (Object[])new Object[]{e1.getLocalizedMessage()}), (String)CvsBundle.message((String)"operation.name.select.tag", (Object[])new Object[0]));
    }

    @Nullable
    private static String chooseFrom(Collection<String> tags, Collection<CvsRevisionNumber> revisions) {
        if (tags == null) {
            return null;
        }
        Collection<String> revisionsNames = TagsHelper.collectSortedRevisionsNames(revisions);
        if (tags.isEmpty() && revisionsNames.isEmpty()) {
            Messages.showMessageDialog((String)CvsBundle.message((String)"message.no.tags.found", (Object[])new Object[0]), (String)CvsBundle.message((String)"operation.name.select.tag", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            return null;
        }
        SelectTagDialog selectTagDialog = new SelectTagDialog(TagsHelper.collectSortedTags(tags), revisionsNames);
        selectTagDialog.show();
        if (selectTagDialog.isOK()) {
            return selectTagDialog.getTag();
        }
        return null;
    }

    private static Collection<String> collectSortedTags(Collection<String> tags) {
        ArrayList<String> result = new ArrayList<String>(tags);
        Collections.sort(result);
        return result;
    }

    private static Collection<String> collectSortedRevisionsNames(Collection<CvsRevisionNumber> revisions) {
        if (revisions == null) {
            return new ArrayList<String>();
        }
        ArrayList<CvsRevisionNumber> list = new ArrayList<CvsRevisionNumber>(revisions);
        Collections.sort(list, new Comparator<CvsRevisionNumber>(){

            @Override
            public int compare(CvsRevisionNumber o, CvsRevisionNumber o1) {
                return o.compareTo((VcsRevisionNumber)o1);
            }
        });
        ArrayList<String> result = new ArrayList<String>();
        for (CvsRevisionNumber aList : list) {
            result.add(aList.toString());
        }
        return result;
    }

    public static Collection<CvsRevisionNumber> getAllRevisions(List<LogInformation> logs) {
        ArrayList<CvsRevisionNumber> result = new ArrayList<CvsRevisionNumber>();
        for (LogInformation log : logs) {
            TagsHelper.collectRevisions(log, result);
        }
        return result;
    }
}

