/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class OrderedSet<T>
extends AbstractSet<T>
implements List<T> {
    private final THashSet<T> myHashSet;
    private final ArrayList<T> myElements;

    public OrderedSet(TObjectHashingStrategy<T> hashingStrategy) {
        this.myHashSet = new THashSet(hashingStrategy);
        this.myElements = new ArrayList();
    }

    public OrderedSet(TObjectHashingStrategy<T> hashingStrategy, int capacity) {
        this.myHashSet = new THashSet(capacity, hashingStrategy);
        this.myElements = new ArrayList(capacity);
    }

    public OrderedSet() {
        this.myHashSet = new THashSet();
        this.myElements = new ArrayList();
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    @Override
    public int size() {
        return this.myElements.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.myHashSet.contains(o);
    }

    @Override
    public boolean add(T o) {
        if (this.myHashSet.add(o)) {
            this.myElements.add(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.myHashSet.remove(o)) {
            this.myElements.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.myHashSet.clear();
        this.myElements.clear();
    }

    @Override
    public Object[] toArray() {
        return this.myElements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.myElements.toArray(a);
    }

    public Object clone() {
        try {
            OrderedSet newSet = (OrderedSet)super.clone();
            newSet.myHashSet.addAll(this.myHashSet);
            newSet.myElements.clear();
            newSet.myElements.addAll(this.myElements);
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(int index) {
        return this.myElements.get(index);
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        if (this.myHashSet.add(element)) {
            this.myElements.add(index, element);
        }
    }

    @Override
    public T remove(int index) {
        T t = this.myElements.remove(index);
        this.myHashSet.remove(t);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        return this.myElements.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.myElements.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.myElements.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.myElements.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.myElements.subList(fromIndex, toIndex);
    }

    private class MyIterator
    implements Iterator<T> {
        private final Iterator<T> myIterator;
        private T myLastObject;

        private MyIterator() {
            this.myIterator = OrderedSet.this.myElements.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.myIterator.hasNext();
        }

        @Override
        public T next() {
            this.myLastObject = this.myIterator.next();
            return this.myLastObject;
        }

        @Override
        public void remove() {
            this.myIterator.remove();
            OrderedSet.this.myHashSet.remove(this.myLastObject);
        }
    }
}

