/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.Enumerator;
import com.intellij.util.diff.IntLCS;
import com.intellij.util.diff.LCSBuilder;
import com.intellij.util.diff.Reindexer;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

public class Diff {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.diff.Diff");

    public static <T> Change buildChanges(T[] objects1, T[] objects2) {
        for (T anObjects1 : objects1) {
            LOG.assertTrue(anObjects1 != null);
        }
        for (T anObjects2 : objects2) {
            LOG.assertTrue(anObjects2 != null);
        }
        Enumerator<T> enumerator = new Enumerator<T>(objects1.length + objects2.length, TObjectHashingStrategy.CANONICAL);
        int[] ints1 = enumerator.enumerate(objects1);
        int[] ints2 = enumerator.enumerate(objects2);
        Reindexer reindexer = new Reindexer();
        int[][] discarded = reindexer.discardUnique(ints1, ints2);
        IntLCS intLCS = new IntLCS(discarded[0], discarded[1]);
        intLCS.execute();
        ChangeBuilder builder = new ChangeBuilder();
        reindexer.reindex(intLCS.getPaths(), builder);
        return builder.getFirstChange();
    }

    public static class ChangeBuilder
    implements LCSBuilder {
        private int myIndex1 = 0;
        private int myIndex2 = 0;
        private Change myFirstChange;
        private Change myLastChange;

        @Override
        public void addChange(int first, int second) {
            Change change = new Change(this.myIndex1, this.myIndex2, first, second, null);
            if (this.myLastChange != null) {
                this.myLastChange.link = change;
            } else {
                this.myFirstChange = change;
            }
            this.myLastChange = change;
            this.skip(first, second);
        }

        private void skip(int first, int second) {
            this.myIndex1 += first;
            this.myIndex2 += second;
        }

        @Override
        public void addEqual(int length) {
            this.skip(length, length);
        }

        public Change getFirstChange() {
            return this.myFirstChange;
        }
    }

    public static class Change {
        public Change link;
        public final int inserted;
        public final int deleted;
        public final int line0;
        public final int line1;

        protected Change(int line0, int line1, int deleted, int inserted, Change old) {
            this.line0 = line0;
            this.line1 = line1;
            this.inserted = inserted;
            this.deleted = deleted;
            this.link = old;
        }

        @NonNls
        public String toString() {
            return "change[inserted=" + this.inserted + ", deleted=" + this.deleted + ", line0=" + this.line0 + ", line1=" + this.line1 + "]";
        }

        public ArrayList<Change> toList() {
            ArrayList<Change> result = new ArrayList<Change>();
            Change current = this;
            while (current != null) {
                result.add(current);
                current = current.link;
            }
            return result;
        }
    }
}

