/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.AccessorBindingWrapper;
import com.intellij.util.xmlb.AttributeBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.FieldAccessor;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.OptionTagBinding;
import com.intellij.util.xmlb.PropertyAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.TagBinding;
import com.intellij.util.xmlb.TextBinding;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

class BeanBinding
implements Binding {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.xmlb.BeanBinding");
    private final String myTagName;
    private final Map<Binding, Accessor> myPropertyBindings = new HashMap<Binding, Accessor>();
    private final List<Binding> myPropertyBindingsList = new ArrayList<Binding>();
    private final Class<?> myBeanClass;
    private final SerializationFilter filter;
    private final XmlSerializerImpl serializer;
    @NonNls
    private static final String CLASS_PROPERTY = "class";
    private final Accessor myAccessor;

    public BeanBinding(Class<?> beanClass, XmlSerializerImpl serializer, Accessor accessor) {
        this.myAccessor = accessor;
        assert (!beanClass.isArray()) : "Bean is an array";
        assert (!beanClass.isPrimitive()) : "Bean is primitive type";
        this.myBeanClass = beanClass;
        this.filter = serializer.getFilter();
        this.serializer = serializer;
        this.myTagName = BeanBinding.getTagName(beanClass);
    }

    @Override
    public void init() {
        this.initPropertyBindings(this.myBeanClass);
    }

    private void initPropertyBindings(Class<?> beanClass) {
        Accessor[] accessors;
        for (Accessor accessor : accessors = BeanBinding.getAccessors(beanClass)) {
            Binding binding = BeanBinding.createBindingByAccessor(this.serializer, accessor);
            this.myPropertyBindingsList.add(binding);
            this.myPropertyBindings.put(binding, accessor);
        }
    }

    @Override
    public Object serialize(Object o, Object context) {
        Element element = new Element(this.myTagName);
        this.serializeInto(o, element);
        return element;
    }

    public void serializeInto(Object o, Element element) {
        for (Binding binding : this.myPropertyBindingsList) {
            Object node;
            Accessor accessor = this.myPropertyBindings.get(binding);
            if (!this.filter.accepts(accessor, o)) continue;
            Property property = XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), Property.class);
            if (property != null) {
                try {
                    if (!property.filter().newInstance().accepts(accessor, o)) {
                        continue;
                    }
                }
                catch (InstantiationException e) {
                    throw new XmlSerializationException(e);
                }
                catch (IllegalAccessException e) {
                    throw new XmlSerializationException(e);
                }
            }
            if ((node = binding.serialize(o, element)) == element) continue;
            if (node instanceof org.jdom.Attribute) {
                org.jdom.Attribute attr = (org.jdom.Attribute)node;
                element.setAttribute(attr.getName(), attr.getValue());
                continue;
            }
            JDOMUtil.addContent(element, node);
        }
    }

    public void deserializeInto(Object bean, Element element) {
        this._deserializeInto(bean, element);
    }

    @Override
    public Object deserialize(Object o, Object ... nodes) {
        return this._deserializeInto(this.instantiateBean(), nodes);
    }

    private Object _deserializeInto(Object result, Object ... aNodes) {
        Object[] children;
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (Object aNode : aNodes) {
            if (XmlSerializerImpl.isIgnoredNode(aNode)) continue;
            nodes.add(aNode);
        }
        if (nodes.size() != 1) {
            throw new XmlSerializationException("Wrong set of nodes: " + nodes + " for bean" + this.myBeanClass + " in " + this.myAccessor);
        }
        assert (nodes.get(0) instanceof Element) : "Wrong node: " + nodes;
        Element e = (Element)nodes.get(0);
        ArrayList<Binding> bindings = new ArrayList<Binding>(this.myPropertyBindings.keySet());
        MultiMap<Binding, Object> data = new MultiMap<Binding, Object>();
        block1: for (Object child : children = JDOMUtil.getChildNodesWithAttrs(e)) {
            if (XmlSerializerImpl.isIgnoredNode(child)) continue;
            for (Binding binding : bindings) {
                if (!binding.isBoundTo(child)) continue;
                data.putValue(binding, child);
                continue block1;
            }
            String message = "Format error: no binding for " + child + " inside " + this;
            LOG.debug(message);
            Logger.getInstance(this.myBeanClass.getName()).debug(message);
            Logger.getInstance("#" + this.myBeanClass.getName()).debug(message);
        }
        Iterator i$ = data.keySet().iterator();
        while (i$.hasNext()) {
            Binding o1;
            Binding binding = o1 = (Binding)i$.next();
            Collection nn = data.get(binding);
            binding.deserialize(result, ArrayUtil.toObjectArray(nn));
        }
        return result;
    }

    private Object instantiateBean() {
        Object result;
        try {
            result = this.myBeanClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new XmlSerializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        return result;
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myTagName);
    }

    @Override
    public Class getBoundNodeType() {
        return Element.class;
    }

    private static String getTagName(Class<?> aClass) {
        Tag tag = aClass.getAnnotation(Tag.class);
        if (tag != null && tag.value().length() != 0) {
            return tag.value();
        }
        return aClass.getSimpleName();
    }

    static Accessor[] getAccessors(Class<?> aClass) {
        try {
            Field[] fields;
            PropertyDescriptor[] propertyDescriptors;
            ArrayList<Accessor> accessors = new ArrayList<Accessor>();
            BeanInfo info = Introspector.getBeanInfo(aClass);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = info.getPropertyDescriptors()) {
                if (propertyDescriptor.getName().equals(CLASS_PROPERTY)) continue;
                Method readMethod = propertyDescriptor.getReadMethod();
                Method writeMethod = propertyDescriptor.getWriteMethod();
                if (readMethod == null || writeMethod == null || XmlSerializerImpl.findAnnotation(readMethod.getAnnotations(), Transient.class) != null || XmlSerializerImpl.findAnnotation(writeMethod.getAnnotations(), Transient.class) != null) continue;
                accessors.add(new PropertyAccessor(propertyDescriptor));
            }
            for (Field field : fields = aClass.getFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || XmlSerializerImpl.findAnnotation(field.getAnnotations(), Transient.class) != null) continue;
                accessors.add(new FieldAccessor(field));
            }
            return accessors.toArray(new Accessor[accessors.size()]);
        }
        catch (IntrospectionException e) {
            throw new XmlSerializationException(e);
        }
    }

    public String toString() {
        return "BeanBinding[" + this.myBeanClass.getName() + ", tagName=" + this.myTagName + "]";
    }

    private static Binding createBindingByAccessor(XmlSerializerImpl xmlSerializer, Accessor accessor) {
        Binding binding = BeanBinding._createBinding(accessor, xmlSerializer);
        binding.init();
        return binding;
    }

    private static Binding _createBinding(Accessor accessor, XmlSerializerImpl xmlSerializer) {
        Property property = XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), Property.class);
        Tag tag = XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), Tag.class);
        Attribute attribute = XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), Attribute.class);
        Text text = XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), Text.class);
        Binding binding = xmlSerializer.getTypeBinding(accessor.getGenericType(), accessor);
        if (binding instanceof JDOMElementBinding) {
            return binding;
        }
        if (text != null) {
            return new TextBinding(accessor, xmlSerializer);
        }
        if (attribute != null) {
            return new AttributeBinding(accessor, attribute, xmlSerializer);
        }
        if (tag != null && tag.value().length() > 0) {
            return new TagBinding(accessor, tag, xmlSerializer);
        }
        boolean surroundWithTag = true;
        if (property != null) {
            surroundWithTag = property.surroundWithTag();
        }
        if (!surroundWithTag) {
            if (!Element.class.isAssignableFrom(binding.getBoundNodeType())) {
                throw new XmlSerializationException("Text-serializable properties can't be serialized without surrounding tags: " + accessor);
            }
            return new AccessorBindingWrapper(accessor, binding);
        }
        return new OptionTagBinding(accessor, xmlSerializer);
    }
}

