/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EqualityToEqualsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class StringEqualityInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.comparison.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/StringEqualityInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.comparison.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/StringEqualityInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectEqualityVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new EqualityToEqualsFix();
    }

    private static class ObjectEqualityVisitor
    extends BaseInspectionVisitor {
        private ObjectEqualityVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/StringEqualityInspection$ObjectEqualityVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            if (!ComparisonUtils.isEqualityComparison(expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            if (!ObjectEqualityVisitor.isStringType(lhs)) {
                return;
            }
            PsiExpression rhs = expression.getROperand();
            if (!ObjectEqualityVisitor.isStringType(rhs)) {
                return;
            }
            String lhsText = lhs.getText();
            if ("null".equals(lhsText)) {
                return;
            }
            if (rhs == null) {
                return;
            }
            String rhsText = rhs.getText();
            if ("null".equals(rhsText)) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            this.registerError((PsiElement)sign, new Object[0]);
        }

        private static boolean isStringType(PsiExpression lhs) {
            if (lhs == null) {
                return false;
            }
            PsiType lhsType = lhs.getType();
            if (lhsType == null) {
                return false;
            }
            return TypeUtils.isJavaLangString(lhsType);
        }
    }
}

