/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import com.siyeh.ig.psiutils.ClassUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class FieldCountInspection
extends ClassMetricInspection {
    private static final int FIELD_COUNT_LIMIT = 10;
    public boolean m_countConstantFields = false;
    public boolean m_considerStaticFinalFieldsConstant = false;

    @NotNull
    public String getID() {
        if ("ClassWithTooManyFields" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/FieldCountInspection.getID must not return null");
        }
        return "ClassWithTooManyFields";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("too.many.fields.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/FieldCountInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("too.many.fields.problem.descriptor", infos[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/FieldCountInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 10;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("too.many.fields.count.limit.option", new Object[0]);
    }

    @Override
    public JComponent createOptionsPanel() {
        String configurationLabel = this.getConfigurationLabel();
        JLabel label = new JLabel(configurationLabel);
        JFormattedTextField valueField = this.prepareNumberEditor("m_limit");
        JCheckBox includeCheckBox = new JCheckBox(InspectionGadgetsBundle.message("field.count.inspection.include.constant.fields.in.count.checkbox", new Object[0]), this.m_countConstantFields);
        final ButtonModel includeModel = includeCheckBox.getModel();
        includeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FieldCountInspection.this.m_countConstantFields = includeModel.isSelected();
            }
        });
        JCheckBox considerCheckBox = new JCheckBox(InspectionGadgetsBundle.message("field.count.inspection.static.final.fields.count.as.constant.checkbox", new Object[0]), this.m_considerStaticFinalFieldsConstant);
        final ButtonModel considerModel = considerCheckBox.getModel();
        considerModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FieldCountInspection.this.m_considerStaticFinalFieldsConstant = considerModel.isSelected();
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        panel.add((Component)valueField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 4;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        panel.add((Component)includeCheckBox, constraints);
        constraints.gridy = 2;
        panel.add((Component)considerCheckBox, constraints);
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldCountVisitor();
    }

    private class FieldCountVisitor
    extends BaseInspectionVisitor {
        private FieldCountVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classmetrics/FieldCountInspection$FieldCountVisitor.visitClass must not be null");
            }
            int totalFields = this.countFields(aClass);
            if (totalFields <= FieldCountInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, totalFields);
        }

        private int countFields(PsiClass aClass) {
            PsiField[] fields;
            int totalFields = 0;
            for (PsiField field : fields = aClass.getFields()) {
                if (FieldCountInspection.this.m_countConstantFields) {
                    ++totalFields;
                    continue;
                }
                if (this.fieldIsConstant(field)) continue;
                ++totalFields;
            }
            return totalFields;
        }

        private boolean fieldIsConstant(PsiField field) {
            if (!field.hasModifierProperty("static")) {
                return false;
            }
            if (!field.hasModifierProperty("final")) {
                return false;
            }
            if (FieldCountInspection.this.m_considerStaticFinalFieldsConstant) {
                return true;
            }
            PsiType type = field.getType();
            return ClassUtils.isImmutable(type);
        }
    }
}

