/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForLoopWithMissingComponentInspection
extends BaseInspection {
    public boolean ignoreCollectionLoops = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/ForLoopWithMissingComponentInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        boolean hasInitializer = (Boolean)infos[0];
        boolean hasCondition = (Boolean)infos[1];
        boolean hasUpdate = (Boolean)infos[2];
        if (hasInitializer) {
            if (!(hasCondition ? (string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor3", new Object[0])) != null : (hasUpdate ? (string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor2", new Object[0])) != null : (string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor6", new Object[0])) != null))) throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/ForLoopWithMissingComponentInspection.buildErrorString must not return null");
            return string;
        }
        if (hasCondition) {
            if (!(hasUpdate ? (string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor1", new Object[0])) != null : (string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor5", new Object[0])) != null)) throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/ForLoopWithMissingComponentInspection.buildErrorString must not return null");
            return string;
        }
        if (hasUpdate) {
            string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor4", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/ForLoopWithMissingComponentInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor7", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/ForLoopWithMissingComponentInspection.buildErrorString must not return null");
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("for.loop.with.missing.component.collection.loop.option", new Object[0]), (InspectionProfileEntry)this, "ignoreCollectionLoops");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopWithMissingComponentVisitor();
    }

    private class ForLoopWithMissingComponentVisitor
    extends BaseInspectionVisitor {
        private ForLoopWithMissingComponentVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/ForLoopWithMissingComponentInspection$ForLoopWithMissingComponentVisitor.visitForStatement must not be null");
            }
            super.visitForStatement(statement);
            boolean hasCondition = this.hasCondition(statement);
            boolean hasInitializer = this.hasInitializer(statement);
            boolean hasUpdate = this.hasUpdate(statement);
            if (hasCondition && hasInitializer && hasUpdate) {
                return;
            }
            if (ForLoopWithMissingComponentInspection.this.ignoreCollectionLoops && this.isCollectionLoopStatement(statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, hasInitializer, hasCondition, hasUpdate);
        }

        private boolean hasCondition(PsiForStatement statement) {
            return statement.getCondition() != null;
        }

        private boolean hasInitializer(PsiForStatement statement) {
            PsiStatement initialization = statement.getInitialization();
            return initialization != null && !(initialization instanceof PsiEmptyStatement);
        }

        private boolean hasUpdate(PsiForStatement statement) {
            PsiStatement update = statement.getUpdate();
            return update != null && !(update instanceof PsiEmptyStatement);
        }

        private boolean isCollectionLoopStatement(PsiForStatement forStatement) {
            PsiStatement initialization = forStatement.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return false;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            if (variable == null) {
                return false;
            }
            PsiType variableType = variable.getType();
            if (!(variableType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)variableType;
            PsiClass declaredClass = classType.resolve();
            if (declaredClass == null) {
                return false;
            }
            if (!ClassUtils.isSubclass(declaredClass, "java.util.Iterator")) {
                return false;
            }
            PsiExpression initialValue = variable.getInitializer();
            if (initialValue == null) {
                return false;
            }
            if (!(initialValue instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression initialCall = (PsiMethodCallExpression)initialValue;
            PsiReferenceExpression initialMethodExpression = initialCall.getMethodExpression();
            String initialCallName = initialMethodExpression.getReferenceName();
            if (!"iterator".equals(initialCallName)) {
                return false;
            }
            String iteratorName = variable.getName();
            PsiExpression condition = forStatement.getCondition();
            return this.isHasNext(condition, iteratorName);
        }

        private boolean isHasNext(PsiExpression condition, String iterator) {
            if (!(condition instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)condition;
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 0) {
                return false;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"hasNext".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return true;
            }
            String target = qualifier.getText();
            return iterator.equals(target);
        }
    }
}

