/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteImportFix;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class RedundantImportInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.import.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/imports/RedundantImportInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.import.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/imports/RedundantImportInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteImportFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantImportVisitor();
    }

    private static class RedundantImportVisitor
    extends BaseInspectionVisitor {
        private RedundantImportVisitor() {
        }

        public void visitFile(PsiFile file) {
            super.visitFile(file);
            if (!(file instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile javaFile = (PsiJavaFile)file;
            if (JspPsiUtil.isInJspFile((PsiElement)file)) {
                return;
            }
            PsiImportList importList = javaFile.getImportList();
            if (importList == null) {
                return;
            }
            this.checkNonStaticImports(importList, javaFile);
            this.checkStaticImports(importList, javaFile);
        }

        private void checkStaticImports(PsiImportList importList, PsiJavaFile javaFile) {
            PsiImportStaticStatement[] importStaticStatements = importList.getImportStaticStatements();
            HashSet<String> staticImports = new HashSet<String>(importStaticStatements.length);
            for (PsiImportStaticStatement importStaticStatement : importStaticStatements) {
                String referenceName = importStaticStatement.getReferenceName();
                PsiClass targetClass = importStaticStatement.resolveTargetClass();
                if (targetClass == null) continue;
                String qualifiedName = targetClass.getQualifiedName();
                if (referenceName == null) {
                    if (staticImports.contains(qualifiedName)) {
                        this.registerError((PsiElement)importStaticStatement, new Object[0]);
                        continue;
                    }
                    staticImports.add(qualifiedName);
                    continue;
                }
                String qualifiedReferenceName = qualifiedName + '.' + referenceName;
                if (staticImports.contains(qualifiedReferenceName)) {
                    this.registerError((PsiElement)importStaticStatement, new Object[0]);
                    continue;
                }
                if (staticImports.contains(qualifiedName) && !ImportUtils.hasOnDemandImportConflict(qualifiedReferenceName, javaFile)) {
                    this.registerError((PsiElement)importStaticStatement, new Object[0]);
                }
                staticImports.add(qualifiedReferenceName);
            }
        }

        private void checkNonStaticImports(PsiImportList importList, PsiJavaFile javaFile) {
            PsiImportStatement[] importStatements = importList.getImportStatements();
            HashSet<String> onDemandImports = new HashSet<String>();
            HashSet<String> singleClassImports = new HashSet<String>();
            for (PsiImportStatement importStatement : importStatements) {
                String contextName;
                PsiElement context;
                String qualifiedName = importStatement.getQualifiedName();
                if (qualifiedName == null) continue;
                if (importStatement.isOnDemand()) {
                    if (onDemandImports.contains(qualifiedName)) {
                        this.registerError((PsiElement)importStatement, new Object[0]);
                    }
                    onDemandImports.add(qualifiedName);
                    continue;
                }
                if (singleClassImports.contains(qualifiedName)) {
                    this.registerError((PsiElement)importStatement, new Object[0]);
                    continue;
                }
                PsiElement element = importStatement.resolve();
                if (!(element instanceof PsiClass) || (context = element.getContext()) == null) continue;
                if (context instanceof PsiJavaFile) {
                    PsiJavaFile file = (PsiJavaFile)context;
                    contextName = file.getPackageName();
                } else {
                    if (!(context instanceof PsiClass)) continue;
                    PsiClass aClass = (PsiClass)context;
                    contextName = aClass.getQualifiedName();
                }
                if (onDemandImports.contains(contextName) && !ImportUtils.hasOnDemandImportConflict(qualifiedName, javaFile) && !ImportUtils.hasDefaultImportConflict(qualifiedName, javaFile)) {
                    this.registerError((PsiElement)importStatement, new Object[0]);
                }
                singleClassImports.add(qualifiedName);
            }
        }
    }
}

