/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.internationalization.NonNlsUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConcatenationInspection
extends BaseInspection {
    public boolean ignoreAsserts = false;
    public boolean ignoreSystemOuts = false;
    public boolean ignoreSystemErrs = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/internationalization/StringConcatenationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/internationalization/StringConcatenationInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiElement expressionParent;
        PsiExpression rhs;
        PsiModifierListOwner element2;
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)infos[0];
        PsiExpression lhs = binaryExpression.getLOperand();
        ArrayList<DelegatingFix> result = new ArrayList<DelegatingFix>();
        PsiModifierListOwner element1 = StringConcatenationInspection.getAnnotatableElement(lhs);
        if (element1 != null) {
            DelegatingFix fix = new DelegatingFix((LocalQuickFix)new AddAnnotationFix("org.jetbrains.annotations.NonNls", element1, new String[0]));
            result.add(fix);
        }
        if ((element2 = StringConcatenationInspection.getAnnotatableElement(rhs = binaryExpression.getROperand())) != null) {
            DelegatingFix fix = new DelegatingFix((LocalQuickFix)new AddAnnotationFix("org.jetbrains.annotations.NonNls", element2, new String[0]));
            result.add(fix);
        }
        if (!((expressionParent = PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, (Class[])new Class[]{PsiReturnStatement.class, PsiExpressionList.class})) instanceof PsiExpressionList) && expressionParent != null) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expressionParent, PsiMethod.class);
            DelegatingFix fix = new DelegatingFix((LocalQuickFix)new AddAnnotationFix("org.jetbrains.annotations.NonNls", (PsiModifierListOwner)method, new String[0]));
            result.add(fix);
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = result.toArray(new InspectionGadgetsFix[result.size()]);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/internationalization/StringConcatenationInspection.buildFixes must not return null");
        }
        return inspectionGadgetsFixArray;
    }

    @Nullable
    public static PsiModifierListOwner getAnnotatableElement(PsiExpression expression) {
        if (!(expression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        PsiElement element = referenceExpression.resolve();
        if (!(element instanceof PsiModifierListOwner)) {
            return null;
        }
        return (PsiModifierListOwner)element;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("string.concatenation.ignore.assert.option", new Object[0]), "ignoreAsserts");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("string.concatenation.ignore.system.out.option", new Object[0]), "ignoreSystemOuts");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("string.concatenation.ignore.system.err.option", new Object[0]), "ignoreSystemErrs");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationVisitor();
    }

    private class StringConcatenationVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/internationalization/StringConcatenationInspection$StringConcatenationVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!JavaTokenType.PLUS.equals(tokenType)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiType lhsType = lhs.getType();
            PsiType rhsType = rhs.getType();
            if (!TypeUtils.isJavaLangString(lhsType) && !TypeUtils.isJavaLangString(rhsType)) {
                return;
            }
            if (NonNlsUtils.isNonNlsAnnotated(lhs) || NonNlsUtils.isNonNlsAnnotated(rhs)) {
                return;
            }
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiAssertStatement.class, PsiMethodCallExpression.class});
            if (StringConcatenationInspection.this.ignoreAsserts && element instanceof PsiAssertStatement) {
                return;
            }
            if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String canonicalText = methodExpression.getCanonicalText();
                if (StringConcatenationInspection.this.ignoreSystemOuts && "System.out.println".equals(canonicalText) || "System.out.print".equals(canonicalText)) {
                    return;
                }
                if (StringConcatenationInspection.this.ignoreSystemErrs && "System.err.println".equals(canonicalText) || "System.err.print".equals(canonicalText)) {
                    return;
                }
            }
            if (NonNlsUtils.isNonNlsAnnotatedUse((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)sign, expression);
        }
    }
}

