/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VarargParameterInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("VariableArgumentMethod" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk/VarargParameterInspection.getID must not return null");
        }
        return "VariableArgumentMethod";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("variable.argument.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk/VarargParameterInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("variable.argument.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk/VarargParameterInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new VarargParameterFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new VarargParameterVisitor();
    }

    private static class VarargParameterVisitor
    extends BaseInspectionVisitor {
        private VarargParameterVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk/VarargParameterInspection$VarargParameterVisitor.visitMethod must not be null");
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() < 1) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter lastParameter = parameters[parameters.length - 1];
            if (lastParameter.isVarArgs()) {
                this.registerMethodError(method, new Object[0]);
            }
        }
    }

    private static class VarargParameterFix
    extends InspectionGadgetsFix {
        private VarargParameterFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("variable.argument.method.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk/VarargParameterInspection$VarargParameterFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)element.getParent();
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter lastParameter = parameters[parameters.length - 1];
            if (!lastParameter.isVarArgs()) {
                return;
            }
            PsiEllipsisType type = (PsiEllipsisType)lastParameter.getType();
            Query query = ReferencesSearch.search((PsiElement)method);
            PsiType componentType = type.getComponentType();
            String typeText = componentType.getCanonicalText();
            Collection references = query.findAll();
            for (PsiReference reference : references) {
                VarargParameterFix.modifyCalls(reference, typeText, parameters.length - 1);
            }
            PsiType arrayType = type.toArrayType();
            PsiManager psiManager = lastParameter.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            PsiTypeElement newTypeElement = factory.createTypeElement(arrayType);
            PsiTypeElement typeElement = lastParameter.getTypeElement();
            typeElement.replace((PsiElement)newTypeElement);
        }

        public static void modifyCalls(PsiReference reference, String arrayTypeText, int indexOfFirstVarargArgument) throws IncorrectOperationException {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)reference.getElement();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)referenceExpression.getParent();
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            StringBuilder builder = new StringBuilder("new ");
            builder.append(arrayTypeText);
            builder.append("[]{");
            if (arguments.length > indexOfFirstVarargArgument) {
                PsiExpression firstArgument = arguments[indexOfFirstVarargArgument];
                String firstArgumentText = firstArgument.getText();
                builder.append(firstArgumentText);
                for (int i = indexOfFirstVarargArgument + 1; i < arguments.length; ++i) {
                    builder.append(',');
                    builder.append(arguments[i].getText());
                }
            }
            builder.append('}');
            PsiManager manager = referenceExpression.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiExpression arrayExpression = factory.createExpressionFromText(builder.toString(), (PsiElement)referenceExpression);
            if (arguments.length > indexOfFirstVarargArgument) {
                PsiExpression firstArgument = arguments[indexOfFirstVarargArgument];
                argumentList.deleteChildRange((PsiElement)firstArgument, (PsiElement)arguments[arguments.length - 1]);
                argumentList.add((PsiElement)arrayExpression);
            } else {
                argumentList.add((PsiElement)arrayExpression);
            }
            CodeStyleManager codeStyleManager = manager.getCodeStyleManager();
            JavaCodeStyleManager.getInstance((Project)manager.getProject()).shortenClassReferences((PsiElement)argumentList);
            codeStyleManager.reformat((PsiElement)argumentList);
        }
    }
}

