/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryParenthesesInspection
extends BaseInspection {
    public boolean ignoreClarifyingParentheses = false;
    public boolean ignoreParenthesesOnConditionals = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.parentheses.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryParenthesesInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.parentheses.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryParenthesesInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unnecessary.parentheses.option", new Object[0]), "ignoreClarifyingParentheses");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unnecessary.parentheses.conditional.option", new Object[0]), "ignoreParenthesesOnConditionals");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryParenthesesVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryParenthesesFix();
    }

    private class UnnecessaryParenthesesVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryParenthesesVisitor() {
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            int childPrecedence;
            PsiElement parent = expression.getParent();
            PsiExpression child = expression.getExpression();
            if (child == null) {
                return;
            }
            if (!(parent instanceof PsiExpression) || parent instanceof PsiParenthesizedExpression) {
                this.registerError((PsiElement)expression, new Object[0]);
                return;
            }
            int parentPrecedence = ParenthesesUtils.getPrecedence((PsiExpression)parent);
            if (parentPrecedence > (childPrecedence = ParenthesesUtils.getPrecedence(child))) {
                PsiConditionalExpression conditionalExpression;
                PsiExpression condition;
                if (UnnecessaryParenthesesInspection.this.ignoreClarifyingParentheses) {
                    if (parent instanceof PsiBinaryExpression && child instanceof PsiBinaryExpression) {
                        return;
                    }
                    if (child instanceof PsiInstanceOfExpression) {
                        return;
                    }
                }
                if (UnnecessaryParenthesesInspection.this.ignoreParenthesesOnConditionals && parent instanceof PsiConditionalExpression && expression == (condition = (conditionalExpression = (PsiConditionalExpression)parent).getCondition())) {
                    return;
                }
                this.registerError((PsiElement)expression, new Object[0]);
                return;
            }
            if (parentPrecedence == childPrecedence && !ParenthesesUtils.areParenthesesNeeded(expression, UnnecessaryParenthesesInspection.this.ignoreClarifyingParentheses)) {
                this.registerError((PsiElement)expression, new Object[0]);
                return;
            }
            super.visitParenthesizedExpression(expression);
        }
    }

    private class UnnecessaryParenthesesFix
    extends InspectionGadgetsFix {
        private UnnecessaryParenthesesFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.parentheses.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryParenthesesInspection$UnnecessaryParenthesesFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiExpression expression = (PsiExpression)descriptor.getPsiElement();
            ParenthesesUtils.removeParentheses(expression, UnnecessaryParenthesesInspection.this.ignoreClarifyingParentheses);
        }
    }
}

