/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class AccessToStaticFieldLockedOnInstanceInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("access.to.static.field.locked.on.instance.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/AccessToStaticFieldLockedOnInstanceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("access.to.static.field.locked.on.instance.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/AccessToStaticFieldLockedOnInstanceInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AccessToStaticFieldLockedOnInstanceVisitor();
    }

    private static class AccessToStaticFieldLockedOnInstanceVisitor
    extends BaseInspectionVisitor {
        private AccessToStaticFieldLockedOnInstanceVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            PsiSynchronizedStatement synchronizedStatement;
            PsiClass expressionClass;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/AccessToStaticFieldLockedOnInstanceInspection$AccessToStaticFieldLockedOnInstanceVisitor.visitReferenceExpression must not be null");
            }
            super.visitReferenceExpression(expression);
            boolean isLockedOnInstance = false;
            boolean isLockedOnClass = false;
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
            if (containingMethod != null && containingMethod.hasModifierProperty("synchronized")) {
                if (containingMethod.hasModifierProperty("static")) {
                    isLockedOnClass = true;
                } else {
                    isLockedOnInstance = true;
                }
            }
            if ((expressionClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class)) == null) {
                return;
            }
            PsiReferenceExpression elementToCheck = expression;
            while ((synchronizedStatement = (PsiSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)elementToCheck, PsiSynchronizedStatement.class)) != null && PsiTreeUtil.isAncestor((PsiElement)expressionClass, (PsiElement)synchronizedStatement, (boolean)true)) {
                PsiExpression lockExpression = synchronizedStatement.getLockExpression();
                if (lockExpression instanceof PsiReferenceExpression) {
                    PsiReferenceExpression reference = (PsiReferenceExpression)lockExpression;
                    PsiElement referent = reference.resolve();
                    if (referent instanceof PsiField) {
                        PsiField referentField = (PsiField)referent;
                        if (referentField.hasModifierProperty("static")) {
                            isLockedOnClass = true;
                        } else {
                            isLockedOnInstance = true;
                        }
                    }
                } else if (lockExpression instanceof PsiThisExpression) {
                    isLockedOnInstance = true;
                } else if (lockExpression instanceof PsiClassObjectAccessExpression) {
                    isLockedOnClass = true;
                }
                elementToCheck = synchronizedStatement;
            }
            if (!isLockedOnInstance || isLockedOnClass) {
                return;
            }
            PsiElement referent = expression.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField referredField = (PsiField)referent;
            if (!referredField.hasModifierProperty("static") || ExpressionUtils.isConstant(referredField)) {
                return;
            }
            PsiClass containingClass = referredField.getContainingClass();
            if (!PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)expression, (boolean)false)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }
}

