/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.external.m2;

import fr.jayasoft.ivy.ArtifactId;
import fr.jayasoft.ivy.Configuration;
import fr.jayasoft.ivy.DefaultArtifact;
import fr.jayasoft.ivy.DefaultDependencyArtifactDescriptor;
import fr.jayasoft.ivy.DefaultDependencyDescriptor;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.matcher.ExactPatternMatcher;
import fr.jayasoft.ivy.parser.AbstractModuleDescriptorParser;
import fr.jayasoft.ivy.parser.ModuleDescriptorParser;
import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.util.XMLHelper;
import fr.jayasoft.ivy.xml.XmlModuleDescriptorWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PomModuleDescriptorParser
extends AbstractModuleDescriptorParser {
    public static final Configuration[] MAVEN2_CONFIGURATIONS = new Configuration[]{new Configuration("default", Configuration.Visibility.PUBLIC, "runtime dependencies and master artifact can be used with this conf", new String[]{"runtime", "master"}), new Configuration("master", Configuration.Visibility.PUBLIC, "contains only the artifact published by this module itself, with no transitive dependencies", new String[0]), new Configuration("compile", Configuration.Visibility.PUBLIC, "this is the default scope, used if none is specified. Compile dependencies are available in all classpaths.", new String[0]), new Configuration("provided", Configuration.Visibility.PUBLIC, "this is much like compile, but indicates you expect the JDK or a container to provide it. It is only available on the compilation classpath, and is not transitive.", new String[0]), new Configuration("runtime", Configuration.Visibility.PUBLIC, "this scope indicates that the dependency is not required for compilation, but is for execution. It is in the runtime and test classpaths, but not the compile classpath.", new String[]{"compile"}), new Configuration("test", Configuration.Visibility.PRIVATE, "this scope indicates that the dependency is not required for normal use of the application, and is only available for the test compilation and execution phases.", new String[0]), new Configuration("system", Configuration.Visibility.PUBLIC, "this scope is similar to provided except that you have to provide the JAR which contains it explicitly. The artifact is always available and is not looked up in a repository.", new String[0])};
    private static final Configuration OPTIONAL_CONFIGURATION = new Configuration("optional", Configuration.Visibility.PUBLIC, "contains all optional dependencies", new String[0]);
    private static final Map MAVEN2_CONF_MAPPING = new HashMap();
    private static PomModuleDescriptorParser INSTANCE;

    public static PomModuleDescriptorParser getInstance() {
        return INSTANCE;
    }

    private PomModuleDescriptorParser() {
    }

    public ModuleDescriptor parseDescriptor(Ivy ivy, URL descriptorURL, Resource res, boolean validate) throws ParseException, IOException {
        Parser parser = new Parser(this, ivy, res);
        try {
            XMLHelper.parse(descriptorURL, null, parser);
        }
        catch (SAXException ex) {
            ParseException pe = new ParseException(ex.getMessage() + " in " + descriptorURL, 0);
            pe.initCause(ex);
            throw pe;
        }
        catch (ParserConfigurationException ex) {
            IllegalStateException ise = new IllegalStateException(ex.getMessage() + " in " + descriptorURL);
            ise.initCause(ex);
            throw ise;
        }
        return parser.getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toIvyFile(InputStream is, Resource res, File destFile, ModuleDescriptor md) throws ParseException, IOException {
        try {
            XmlModuleDescriptorWriter.write(md, destFile);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public boolean accept(Resource res) {
        return res.getName().endsWith(".pom") || res.getName().endsWith("pom.xml") || res.getName().endsWith("project.xml");
    }

    public String toString() {
        return "pom parser";
    }

    static {
        MAVEN2_CONF_MAPPING.put("compile", "compile->@(*),master(*);runtime->@(*)");
        MAVEN2_CONF_MAPPING.put("provided", "provided->compile(*),provided(*),runtime(*),master(*)");
        MAVEN2_CONF_MAPPING.put("runtime", "runtime->compile(*),runtime(*),master(*)");
        MAVEN2_CONF_MAPPING.put("test", "test->compile(*),runtime(*),master(*)");
        MAVEN2_CONF_MAPPING.put("system", "system->master(*)");
        INSTANCE = new PomModuleDescriptorParser();
    }

    private static final class Parser
    extends AbstractModuleDescriptorParser.AbstractParser {
        private Ivy _ivy;
        private Stack _contextStack = new Stack();
        private String _organisation;
        private String _module;
        private String _revision;
        private String _scope;
        private boolean _optional = false;
        private List _exclusions = new ArrayList();
        private DefaultDependencyDescriptor _dd;
        private Map _properties = new HashMap();

        public Parser(ModuleDescriptorParser parser, Ivy ivy, Resource res) {
            super(parser);
            this._ivy = ivy;
            this.setResource(res);
            this._md.setResolvedPublicationDate(new Date(res.getLastModified()));
            for (int i = 0; i < MAVEN2_CONFIGURATIONS.length; ++i) {
                this._md.addConfiguration(MAVEN2_CONFIGURATIONS[i]);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this._contextStack.push(qName);
            if ("optional".equals(qName)) {
                this._optional = true;
            } else if ("exclusions".equals(qName)) {
                if (this._dd == null) {
                    this._dd = new DefaultDependencyDescriptor(this._md, ModuleRevisionId.newInstance(this._organisation, this._module, this._revision), true, false, true);
                    this._organisation = null;
                    this._module = null;
                    this._revision = null;
                }
            } else if (this._md.getModuleRevisionId() == null && "project/dependencies/dependency".equals(this.getContext())) {
                this.fillMrid();
            }
        }

        private void fillMrid() throws SAXException {
            if (this._organisation == null) {
                throw new SAXException("no groupId found in pom");
            }
            if (this._module == null) {
                throw new SAXException("no artifactId found in pom");
            }
            if (this._revision == null) {
                this._revision = "SNAPSHOT";
            }
            ModuleRevisionId mrid = ModuleRevisionId.newInstance(this._organisation, this._module, this._revision);
            this._properties.put("pom.version", this._revision);
            this._md.setModuleRevisionId(mrid);
            this._md.addArtifact("master", new DefaultArtifact(mrid, this.getDefaultPubDate(), this._module, "jar", "jar"));
            this._organisation = null;
            this._module = null;
            this._revision = null;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this._md.getModuleRevisionId() == null && "project".equals(this.getContext())) {
                this.fillMrid();
            } else if ((this._organisation != null && this._module != null && this._revision != null || this._dd != null) && "project/dependencies/dependency".equals(this.getContext())) {
                String mapping;
                if (this._dd == null) {
                    this._dd = new DefaultDependencyDescriptor(this._md, ModuleRevisionId.newInstance(this._organisation, this._module, this._revision), true, false, true);
                }
                String string = this._scope = this._scope == null ? "compile" : this._scope;
                if (this._optional && "compile".equals(this._scope)) {
                    this._scope = "runtime";
                }
                if ((mapping = (String)MAVEN2_CONF_MAPPING.get(this._scope)) == null) {
                    Message.verbose("unknown scope " + this._scope + " in " + this.getResource());
                    mapping = (String)MAVEN2_CONF_MAPPING.get("compile");
                }
                if (this._optional) {
                    mapping = mapping.replaceAll(this._scope + "\\-\\>", "optional->");
                    if (this._md.getConfiguration("optional") == null) {
                        this._md.addConfiguration(OPTIONAL_CONFIGURATION);
                    }
                }
                this.parseDepsConfs(mapping, this._dd);
                Iterator iter = this._exclusions.iterator();
                while (iter.hasNext()) {
                    ModuleId mid = (ModuleId)iter.next();
                    String[] confs = this._dd.getModuleConfigurations();
                    for (int i = 0; i < confs.length; ++i) {
                        this._dd.addDependencyArtifactExcludes(confs[i], new DefaultDependencyArtifactDescriptor(this._dd, new ArtifactId(mid, "*", "*", "*"), false, ExactPatternMatcher.getInstance()));
                    }
                }
                this._md.addDependency(this._dd);
                this._dd = null;
            } else if (this._organisation != null && this._module != null && "project/dependencies/dependency/exclusions/exclusion".equals(this.getContext())) {
                this._exclusions.add(new ModuleId(this._organisation, this._module));
                this._organisation = null;
                this._module = null;
            }
            if ("dependency".equals(qName)) {
                this._organisation = null;
                this._module = null;
                this._revision = null;
                this._scope = null;
                this._optional = false;
                this._exclusions.clear();
            }
            this._contextStack.pop();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String txt = IvyPatternHelper.substituteVariables(new String(ch, start, length).trim(), this._properties);
            if (txt.trim().length() == 0) {
                return;
            }
            String context = this.getContext();
            if (context.equals("project/parent/groupId") && this._organisation == null) {
                this._organisation = txt;
                return;
            }
            if (context.startsWith("project/parent")) {
                return;
            }
            if (this._md.getModuleRevisionId() == null || context.startsWith("project/dependencies/dependency")) {
                if (context.equals("project/groupId")) {
                    this._organisation = txt;
                } else if (this._organisation == null && context.endsWith("groupId")) {
                    this._organisation = txt;
                } else if (this._module == null && context.endsWith("artifactId")) {
                    this._module = txt;
                } else if (this._revision == null && context.endsWith("version")) {
                    this._revision = txt;
                } else if (this._scope == null && context.endsWith("scope")) {
                    this._scope = txt;
                }
            }
        }

        private String getContext() {
            StringBuffer buf = new StringBuffer();
            Iterator iter = this._contextStack.iterator();
            while (iter.hasNext()) {
                String ctx = (String)iter.next();
                buf.append(ctx).append("/");
            }
            if (buf.length() > 0) {
                buf.setLength(buf.length() - 1);
            }
            return buf.toString();
        }

        public ModuleDescriptor getDescriptor() {
            if (this._md.getModuleRevisionId() == null) {
                return null;
            }
            return this._md;
        }
    }
}

