/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.Debug;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;

final class CipherBox {
    static final CipherBox NULL = new CipherBox();
    private static final Debug debug = Debug.getInstance("ssl");
    private final ProtocolVersion protocolVersion;
    private final Cipher cipher;
    private int blockSize;
    private SecureRandom random;
    private final boolean isCBCMode;
    private static Hashtable<Integer, IvParameterSpec> masks;

    private CipherBox() {
        this.protocolVersion = ProtocolVersion.DEFAULT;
        this.cipher = null;
        this.isCBCMode = false;
    }

    private CipherBox(ProtocolVersion protocolVersion, CipherSuite.BulkCipher bulkCipher, SecretKey secretKey, IvParameterSpec ivParameterSpec, SecureRandom secureRandom, boolean bl) throws NoSuchAlgorithmException {
        try {
            int n;
            this.protocolVersion = protocolVersion;
            this.cipher = JsseJce.getCipher(bulkCipher.transformation);
            int n2 = n = bl ? 1 : 2;
            if (secureRandom == null) {
                secureRandom = JsseJce.getSecureRandom();
            }
            this.random = secureRandom;
            this.isCBCMode = bulkCipher.isCBCMode;
            if (ivParameterSpec == null && bulkCipher.ivSize != 0 && n == 2 && protocolVersion.v >= ProtocolVersion.TLS11.v) {
                ivParameterSpec = CipherBox.getFixedMask(bulkCipher.ivSize);
            }
            this.cipher.init(n, (Key)secretKey, ivParameterSpec, secureRandom);
            this.blockSize = this.cipher.getBlockSize();
            if (this.blockSize == 1) {
                this.blockSize = 0;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException("Could not create cipher " + bulkCipher, exception);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new NoSuchAlgorithmException("Could not create cipher " + bulkCipher, exceptionInInitializerError);
        }
    }

    static CipherBox newCipherBox(ProtocolVersion protocolVersion, CipherSuite.BulkCipher bulkCipher, SecretKey secretKey, IvParameterSpec ivParameterSpec, SecureRandom secureRandom, boolean bl) throws NoSuchAlgorithmException {
        if (!bulkCipher.allowed) {
            throw new NoSuchAlgorithmException("Unsupported cipher " + bulkCipher);
        }
        if (bulkCipher == CipherSuite.B_NULL) {
            return NULL;
        }
        return new CipherBox(protocolVersion, bulkCipher, secretKey, ivParameterSpec, secureRandom, bl);
    }

    private static IvParameterSpec getFixedMask(int n) {
        IvParameterSpec ivParameterSpec;
        if (masks == null) {
            masks = new Hashtable(5);
        }
        if ((ivParameterSpec = masks.get(n)) == null) {
            ivParameterSpec = new IvParameterSpec(new byte[n]);
            masks.put(n, ivParameterSpec);
        }
        return ivParameterSpec;
    }

    int encrypt(byte[] byArray, int n, int n2) {
        if (this.cipher == null) {
            return n2;
        }
        try {
            int n3;
            Object object;
            if (this.blockSize != 0) {
                if (this.protocolVersion.v >= ProtocolVersion.TLS11.v) {
                    object = new byte[this.blockSize];
                    this.random.nextBytes((byte[])object);
                    System.arraycopy(byArray, n, byArray, n + ((byte[])object).length, n2);
                    System.arraycopy(object, 0, byArray, n, ((byte[])object).length);
                    n2 += ((byte[])object).length;
                }
                n2 = CipherBox.addPadding(byArray, n, n2, this.blockSize);
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    object = new HexDumpEncoder();
                    System.out.println("Padded plaintext before ENCRYPTION:  len = " + n2);
                    object.encodeBuffer((InputStream)new ByteArrayInputStream(byArray, n, n2), (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((n3 = this.cipher.update(byArray, n, n2, byArray, n)) != n2) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            return n3;
        }
        catch (ShortBufferException shortBufferException) {
            throw new ArrayIndexOutOfBoundsException(shortBufferException.toString());
        }
    }

    int encrypt(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (this.cipher == null) {
            byteBuffer.position(byteBuffer.limit());
            return n;
        }
        try {
            Object object;
            int n2 = byteBuffer.position();
            if (this.blockSize != 0) {
                if (this.protocolVersion.v >= ProtocolVersion.TLS11.v) {
                    object = new byte[this.blockSize];
                    this.random.nextBytes((byte[])object);
                    byte[] byArray = null;
                    int n3 = byteBuffer.limit();
                    if (byteBuffer.hasArray()) {
                        int n4 = byteBuffer.arrayOffset();
                        byArray = byteBuffer.array();
                        System.arraycopy(byArray, n4 + n2, byArray, n4 + n2 + ((Object)object).length, n3 - n2);
                        byteBuffer.limit(n3 + ((Object)object).length);
                    } else {
                        byArray = new byte[n3 - n2];
                        byteBuffer.get(byArray, 0, n3 - n2);
                        byteBuffer.position(n2 + ((Object)object).length);
                        byteBuffer.limit(n3 + ((Object)object).length);
                        byteBuffer.put(byArray);
                    }
                    byteBuffer.position(n2);
                    byteBuffer.put((byte[])object);
                    byteBuffer.position(n2);
                }
                n = CipherBox.addPadding(byteBuffer, this.blockSize);
                byteBuffer.position(n2);
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    object = new HexDumpEncoder();
                    System.out.println("Padded plaintext before ENCRYPTION:  len = " + n);
                    object.encodeBuffer(byteBuffer, (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                byteBuffer.position(n2);
            }
            object = byteBuffer.duplicate();
            int n5 = this.cipher.update((ByteBuffer)object, byteBuffer);
            if (byteBuffer.position() != ((Buffer)object).position()) {
                throw new RuntimeException("bytebuffer padding error");
            }
            if (n5 != n) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            return n5;
        }
        catch (ShortBufferException shortBufferException) {
            RuntimeException runtimeException = new RuntimeException(shortBufferException.toString());
            runtimeException.initCause(shortBufferException);
            throw runtimeException;
        }
    }

    int decrypt(byte[] byArray, int n, int n2) throws BadPaddingException {
        if (this.cipher == null) {
            return n2;
        }
        try {
            int n3 = this.cipher.update(byArray, n, n2, byArray, n);
            if (n3 != n2) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    System.out.println("Padded plaintext after DECRYPTION:  len = " + n3);
                    hexDumpEncoder.encodeBuffer((InputStream)new ByteArrayInputStream(byArray, n, n3), (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.blockSize != 0) {
                n3 = CipherBox.removePadding(byArray, n, n3, this.blockSize, this.protocolVersion);
                if (this.protocolVersion.v >= ProtocolVersion.TLS11.v) {
                    if (n3 < this.blockSize) {
                        throw new BadPaddingException("invalid explicit IV");
                    }
                    System.arraycopy(byArray, n + this.blockSize, byArray, n, n3 - this.blockSize);
                    n3 -= this.blockSize;
                }
            }
            return n3;
        }
        catch (ShortBufferException shortBufferException) {
            throw new ArrayIndexOutOfBoundsException(shortBufferException.toString());
        }
    }

    int decrypt(ByteBuffer byteBuffer) throws BadPaddingException {
        int n = byteBuffer.remaining();
        if (this.cipher == null) {
            byteBuffer.position(byteBuffer.limit());
            return n;
        }
        try {
            Object object;
            int n2 = byteBuffer.position();
            ByteBuffer byteBuffer2 = byteBuffer.duplicate();
            int n3 = this.cipher.update(byteBuffer2, byteBuffer);
            if (n3 != n) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            if (debug != null && Debug.isOn("plaintext")) {
                byteBuffer.position(n2);
                try {
                    object = new HexDumpEncoder();
                    System.out.println("Padded plaintext after DECRYPTION:  len = " + n3);
                    object.encodeBuffer(byteBuffer, (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.blockSize != 0) {
                byteBuffer.position(n2);
                n3 = CipherBox.removePadding(byteBuffer, this.blockSize, this.protocolVersion);
                if (this.protocolVersion.v >= ProtocolVersion.TLS11.v) {
                    if (n3 < this.blockSize) {
                        throw new BadPaddingException("invalid explicit IV");
                    }
                    object = null;
                    int n4 = byteBuffer.limit();
                    if (byteBuffer.hasArray()) {
                        int n5 = byteBuffer.arrayOffset();
                        object = byteBuffer.array();
                        System.arraycopy(object, n5 + n2 + this.blockSize, object, n5 + n2, n4 - n2 - this.blockSize);
                        byteBuffer.limit(n4 - this.blockSize);
                    } else {
                        object = new byte[n4 - n2 - this.blockSize];
                        byteBuffer.position(n2 + this.blockSize);
                        byteBuffer.get((byte[])object);
                        byteBuffer.position(n2);
                        byteBuffer.put((byte[])object);
                        byteBuffer.limit(n4 - this.blockSize);
                    }
                    n4 = byteBuffer.limit();
                    byteBuffer.position(n4);
                }
            }
            return n3;
        }
        catch (ShortBufferException shortBufferException) {
            RuntimeException runtimeException = new RuntimeException(shortBufferException.toString());
            runtimeException.initCause(shortBufferException);
            throw runtimeException;
        }
    }

    private static int addPadding(byte[] byArray, int n, int n2, int n3) {
        int n4 = n2 + 1;
        if (n4 % n3 != 0) {
            n4 += n3 - 1;
            n4 -= n4 % n3;
        }
        int n5 = n4 - n2;
        if (byArray.length < n4 + n) {
            throw new IllegalArgumentException("no space to pad buffer");
        }
        n += n2;
        for (int i = 0; i < n5; ++i) {
            byArray[n++] = (byte)(n5 - 1);
        }
        return n4;
    }

    private static int addPadding(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.remaining();
        int n3 = byteBuffer.position();
        int n4 = n2 + 1;
        if (n4 % n != 0) {
            n4 += n - 1;
            n4 -= n4 % n;
        }
        int n5 = n4 - n2;
        byteBuffer.limit(n4 + n3);
        n3 += n2;
        for (int i = 0; i < n5; ++i) {
            byteBuffer.put(n3++, (byte)(n5 - 1));
        }
        byteBuffer.position(n3);
        byteBuffer.limit(n3);
        return n4;
    }

    private static int removePadding(byte[] byArray, int n, int n2, int n3, ProtocolVersion protocolVersion) throws BadPaddingException {
        int n4 = n + n2 - 1;
        int n5 = byArray[n4] & 0xFF;
        int n6 = n2 - (n5 + 1);
        if (n6 < 0) {
            throw new BadPaddingException("Padding length invalid: " + n5);
        }
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            for (int i = 1; i <= n5; ++i) {
                int n7 = byArray[n4 - i] & 0xFF;
                if (n7 == n5) continue;
                throw new BadPaddingException("Invalid TLS padding: " + n7);
            }
        } else if (n5 > n3) {
            throw new BadPaddingException("Invalid SSLv3 padding: " + n5);
        }
        return n6;
    }

    private static int removePadding(ByteBuffer byteBuffer, int n, ProtocolVersion protocolVersion) throws BadPaddingException {
        int n2;
        int n3;
        int n4;
        int n5 = byteBuffer.remaining();
        int n6 = n5 - ((n4 = byteBuffer.get(n3 = (n2 = byteBuffer.position()) + n5 - 1) & 0xFF) + 1);
        if (n6 < 0) {
            throw new BadPaddingException("Padding length invalid: " + n4);
        }
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            byteBuffer.put(n3, (byte)0);
            for (int i = 1; i <= n4; ++i) {
                int n7 = byteBuffer.get(n3 - i) & 0xFF;
                if (n7 == n4) continue;
                throw new BadPaddingException("Invalid TLS padding: " + n7);
            }
        } else if (n4 > n) {
            throw new BadPaddingException("Invalid SSLv3 padding: " + n4);
        }
        byteBuffer.position(n2 + n6);
        byteBuffer.limit(n2 + n6);
        return n6;
    }

    void dispose() {
        try {
            if (this.cipher != null) {
                this.cipher.doFinal();
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
    }

    boolean isCBCMode() {
        return this.isCBCMode;
    }
}

