/*
 * Decompiled with CFR 0.152.
 */
package transparentruler;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class Ruler
extends JFrame {
    private static final Color BACKGROUND = Color.RED;
    private static final Color FOREGROUND = Color.WHITE;
    private static final int OPACITY = 180;
    private static final int W = 70;
    private static final int F_HEIGHT = 400;
    private static final int F_WIDTH = 647;
    private final ComponentAdapter componentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            int n = Ruler.this.getHeight();
            int n2 = Ruler.this.getWidth();
            float f = (float)Math.hypot(n, n2);
            Path2D.Float float_ = new Path2D.Float();
            float_.moveTo(0.0f, 0.0f);
            float_.lineTo(n2, 0.0f);
            float_.lineTo(0.0f, n);
            float_.closePath();
            float_.moveTo(70.0f, 70.0f);
            float_.lineTo(70.0f, (float)n - 70.0f * (f + (float)n) / (float)n2);
            float_.lineTo((float)n2 - 70.0f * (f + (float)n2) / (float)n, 70.0f);
            float_.closePath();
            Ruler.this.setShape(float_);
        }
    };
    private final Action exitAction = new AbstractAction("Exit"){
        {
            this.putValue("MnemonicKey", 88);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    };
    private final JPopupMenu jPopupMenu = new JPopupMenu();
    private final MouseAdapter mouseListener;
    private final KeyAdapter keyboardListener;

    private static void checkTranslucencyMode(GraphicsDevice.WindowTranslucency windowTranslucency) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        if (!graphicsDevice.isWindowTranslucencySupported(windowTranslucency)) {
            System.err.println("'" + (Object)((Object)windowTranslucency) + "' translucency mode isn't supported.");
            System.exit(-1);
        }
    }

    public Ruler() {
        this.jPopupMenu.add(new JMenuItem(this.exitAction));
        this.mouseListener = new MouseAdapter(){
            int x;
            int y;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    this.x = mouseEvent.getX();
                    this.y = mouseEvent.getY();
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiersEx() & 0x400) != 0) {
                    Ruler.this.setLocation(mouseEvent.getXOnScreen() - this.x, mouseEvent.getYOnScreen() - this.y);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    Ruler.this.jPopupMenu.show(Ruler.this.getContentPane(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.keyboardListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.isControlDown() ? 50 : (keyEvent.isAltDown() ? 1 : 5);
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        Ruler.this.setLocation(Ruler.this.getX() - n, Ruler.this.getY());
                        break;
                    }
                    case 39: {
                        Ruler.this.setLocation(Ruler.this.getX() + n, Ruler.this.getY());
                        break;
                    }
                    case 38: {
                        Ruler.this.setLocation(Ruler.this.getX(), Ruler.this.getY() - n);
                        break;
                    }
                    case 40: {
                        Ruler.this.setLocation(Ruler.this.getX(), Ruler.this.getY() + n);
                        break;
                    }
                    case 27: {
                        Ruler.this.exitAction.actionPerformed(null);
                    }
                }
            }
        };
        this.setUndecorated(true);
        this.setBackground(new Color(BACKGROUND.getRed(), BACKGROUND.getGreen(), BACKGROUND.getBlue(), 180));
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.addComponentListener(this.componentListener);
        this.addKeyListener(this.keyboardListener);
        this.setContentPane(new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                Graphics graphics2 = graphics.create();
                int n = this.getWidth();
                int n2 = this.getHeight();
                int n3 = graphics2.getFontMetrics().getAscent();
                graphics2.setColor(FOREGROUND);
                for (int i = 0; i < n * (n2 - 8) / n2 - 5; i += 5) {
                    boolean bl;
                    boolean bl2 = bl = i % 50 == 0;
                    graphics2.drawLine(i + 5, 0, i + 5, bl ? 20 : (i % 25 == 0 ? 13 : 8));
                    if (!bl) continue;
                    String string = Integer.toString(i);
                    int n4 = graphics2.getFontMetrics().stringWidth(string);
                    graphics2.drawString(string, i + 5 - n4 / 2, 20 + n3);
                }
                graphics2.dispose();
            }
        });
        this.setDefaultCloseOperation(3);
        this.setSize(647, 400);
        this.setLocationByPlatform(true);
    }

    public static void main(String[] stringArray) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Ruler.checkTranslucencyMode(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSLUCENT);
                Ruler.checkTranslucencyMode(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSPARENT);
                Ruler ruler = new Ruler();
                ruler.setVisible(true);
            }
        });
    }
}

