/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.g1;

import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_implementation.g1.G1MonitoringSupport;
import sun.jvm.hotspot.gc_implementation.g1.HeapRegion;
import sun.jvm.hotspot.gc_implementation.g1.HeapRegionSeq;
import sun.jvm.hotspot.gc_interface.CollectedHeapName;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.memory.SharedHeap;
import sun.jvm.hotspot.memory.SpaceClosure;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class G1CollectedHeap
extends SharedHeap {
    private static long hrsFieldOffset;
    private static long g1CommittedFieldOffset;
    private static CIntegerField summaryBytesUsedField;
    private static AddressField g1mmField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("G1CollectedHeap");
        hrsFieldOffset = type.getField("_hrs").getOffset();
        g1CommittedFieldOffset = type.getField("_g1_committed").getOffset();
        summaryBytesUsedField = type.getCIntegerField("_summary_bytes_used");
        g1mmField = type.getAddressField("_g1mm");
    }

    @Override
    public long capacity() {
        Address g1CommittedAddr = this.addr.addOffsetTo(g1CommittedFieldOffset);
        MemRegion g1_committed = new MemRegion(g1CommittedAddr);
        return g1_committed.byteSize();
    }

    @Override
    public long used() {
        return summaryBytesUsedField.getValue(this.addr);
    }

    public long n_regions() {
        return this.hrs().length();
    }

    private HeapRegionSeq hrs() {
        Address hrsAddr = this.addr.addOffsetTo(hrsFieldOffset);
        return (HeapRegionSeq)VMObjectFactory.newObject(HeapRegionSeq.class, hrsAddr);
    }

    public G1MonitoringSupport g1mm() {
        Address g1mmAddr = g1mmField.getValue(this.addr);
        return (G1MonitoringSupport)VMObjectFactory.newObject(G1MonitoringSupport.class, g1mmAddr);
    }

    private Iterator<HeapRegion> heapRegionIterator() {
        return this.hrs().heapRegionIterator();
    }

    public void heapRegionIterate(SpaceClosure scl) {
        Iterator<HeapRegion> iter = this.heapRegionIterator();
        while (iter.hasNext()) {
            HeapRegion hr = iter.next();
            scl.doSpace(hr);
        }
    }

    @Override
    public CollectedHeapName kind() {
        return CollectedHeapName.G1_COLLECTED_HEAP;
    }

    public G1CollectedHeap(Address addr) {
        super(addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                G1CollectedHeap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

