/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoScaleAction
extends JosmAction {
    public static final String[] MODES = new String[]{I18n.marktr("data"), I18n.marktr("layer"), I18n.marktr("selection"), I18n.marktr("conflict"), I18n.marktr("download"), I18n.marktr("previous"), I18n.marktr("next")};
    private final String mode;
    private ZoomChangeAdapter zoomChangeAdapter;

    public static void zoomToSelection() {
        if (Main.main == null || Main.main.getEditLayer() == null) {
            return;
        }
        if (Main.map == null || Main.map.mapView == null) {
            return;
        }
        Collection<OsmPrimitive> sel = Main.main.getEditLayer().data.getSelected();
        if (sel.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing selected to zoom to."), I18n.tr("Information"), 1);
            return;
        }
        AutoScaleAction.zoomTo(sel);
    }

    public static void zoomTo(Collection<OsmPrimitive> sel) {
        BoundingXYVisitor bboxCalculator = new BoundingXYVisitor();
        bboxCalculator.computeBoundingBox(sel);
        bboxCalculator.enlargeBoundingBox();
        if (bboxCalculator.getBounds() != null) {
            Main.map.mapView.recalculateCenterScale(bboxCalculator);
        }
    }

    public static void autoScale(String mode) {
        new AutoScaleAction(mode, false).autoScale();
    }

    private static int getModeShortcut(String mode) {
        int shortcut = -1;
        if (mode.equals("data")) {
            shortcut = 49;
        }
        if (mode.equals("layer")) {
            shortcut = 50;
        }
        if (mode.equals("selection")) {
            shortcut = 51;
        }
        if (mode.equals("conflict")) {
            shortcut = 52;
        }
        if (mode.equals("download")) {
            shortcut = 53;
        }
        if (mode.equals("previous")) {
            shortcut = 56;
        }
        if (mode.equals("next")) {
            shortcut = 57;
        }
        return shortcut;
    }

    private AutoScaleAction(String mode, boolean marker) {
        super(false);
        this.mode = mode;
    }

    public AutoScaleAction(String mode) {
        super(I18n.tr("Zoom to {0}", I18n.tr(mode)), "dialogs/autoscale/" + mode, I18n.tr("Zoom the view to {0}.", I18n.tr(mode)), Shortcut.registerShortcut("view:zoom" + mode, I18n.tr("View: {0}", I18n.tr("Zoom to {0}", I18n.tr(mode))), AutoScaleAction.getModeShortcut(mode), 3), true);
        String modeHelp = Character.toUpperCase(mode.charAt(0)) + mode.substring(1);
        this.putValue("help", "Action/AutoScale/" + modeHelp);
        this.mode = mode;
        if (mode.equals("data")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomToData"));
        } else if (mode.equals("layer")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomToLayer"));
        } else if (mode.equals("selection")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomToSelection"));
        } else if (mode.equals("conflict")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomToConflict"));
        } else if (mode.equals("download")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomToDownload"));
        } else if (mode.equals("previous")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomPrevious"));
        } else if (mode.equals("next")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomNext"));
        }
    }

    public void autoScale() {
        if (Main.map != null) {
            if (this.mode.equals("previous")) {
                Main.map.mapView.zoomPrevious();
            } else if (this.mode.equals("next")) {
                Main.map.mapView.zoomNext();
            } else {
                BoundingXYVisitor bbox = this.getBoundingBox();
                if (bbox != null && bbox.getBounds() != null) {
                    Main.map.mapView.recalculateCenterScale(bbox);
                }
            }
        }
        this.putValue("active", true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.autoScale();
    }

    protected Layer getActiveLayer() {
        try {
            return Main.map.mapView.getActiveLayer();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    protected Layer getFirstSelectedLayer() {
        if (LayerListDialog.getInstance() == null) {
            return null;
        }
        List<Layer> layers = LayerListDialog.getInstance().getModel().getSelectedLayers();
        if (layers.isEmpty()) {
            return null;
        }
        return layers.get(0);
    }

    private BoundingXYVisitor getBoundingBox() {
        BoundingXYVisitor v;
        block11: {
            block13: {
                block12: {
                    block10: {
                        v = new BoundingXYVisitor();
                        if (!this.mode.equals("data")) break block10;
                        for (Layer l : Main.map.mapView.getAllLayers()) {
                            l.visitBoundingBox(v);
                        }
                        break block11;
                    }
                    if (!this.mode.equals("layer")) break block12;
                    if (this.getActiveLayer() == null) {
                        return null;
                    }
                    Layer l = this.getFirstSelectedLayer();
                    if (l == null) {
                        return null;
                    }
                    l.visitBoundingBox(v);
                    break block11;
                }
                if (!this.mode.equals("selection") && !this.mode.equals("conflict")) break block13;
                Collection<Object> sel = new HashSet();
                if (this.mode.equals("selection")) {
                    sel = this.getCurrentDataSet().getSelected();
                } else if (this.mode.equals("conflict") && Main.map.conflictDialog.getConflicts() != null) {
                    sel = Main.map.conflictDialog.getConflicts().getMyConflictParties();
                }
                if (sel.isEmpty()) {
                    JOptionPane.showMessageDialog(Main.parent, this.mode.equals("selection") ? I18n.tr("Nothing selected to zoom to.") : I18n.tr("No conflicts to zoom to"), I18n.tr("Information"), 1);
                    return null;
                }
                for (OsmPrimitive osmPrimitive : sel) {
                    osmPrimitive.visit(v);
                }
                v.enlargeBoundingBox();
                break block11;
            }
            if (!this.mode.equals("download") || !Main.pref.hasKey("osm-download.bounds")) break block11;
            try {
                v.visit(new Bounds(Main.pref.get("osm-download.bounds"), ";"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return v;
    }

    @Override
    protected void updateEnabledState() {
        if ("selection".equals(this.mode)) {
            this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
        } else if ("layer".equals(this.mode)) {
            if (Main.map == null || Main.map.mapView == null || Main.map.mapView.getAllLayersAsList().isEmpty()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        } else if ("previous".equals(this.mode)) {
            this.setEnabled(Main.map != null && Main.map.mapView != null && Main.map.mapView.hasZoomUndoEntries());
        } else if ("next".equals(this.mode)) {
            this.setEnabled(Main.map != null && Main.map.mapView != null && Main.map.mapView.hasZoomRedoEntries());
        } else {
            this.setEnabled(Main.isDisplayingMapView() && Main.map.mapView.hasLayers());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if ("selection".equals(this.mode)) {
            this.setEnabled(selection != null && !selection.isEmpty());
        }
    }

    @Override
    protected void installAdapters() {
        super.installAdapters();
        this.zoomChangeAdapter = new ZoomChangeAdapter();
        MapView.addZoomChangeListener(this.zoomChangeAdapter);
        this.initEnabledState();
    }

    private class ZoomChangeAdapter
    implements NavigatableComponent.ZoomChangeListener {
        private ZoomChangeAdapter() {
        }

        public void zoomChanged() {
            AutoScaleAction.this.updateEnabledState();
        }
    }
}

