/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Command
extends PseudoCommand {
    private Map<OsmPrimitive, PrimitiveData> cloneMap = new HashMap<OsmPrimitive, PrimitiveData>();
    private OsmDataLayer layer;

    public Command() {
        this.layer = Main.map.mapView.getEditLayer();
    }

    public Command(OsmDataLayer layer) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.layer = layer;
    }

    public boolean executeCommand() {
        CloneVisitor visitor = new CloneVisitor();
        ArrayList<OsmPrimitive> all = new ArrayList<OsmPrimitive>();
        this.fillModifiedData(all, all, all);
        for (OsmPrimitive osm : all) {
            osm.visit(visitor);
        }
        this.cloneMap = visitor.orig;
        return true;
    }

    public void undoCommand() {
        for (Map.Entry<OsmPrimitive, PrimitiveData> e : this.cloneMap.entrySet()) {
            OsmPrimitive primitive = e.getKey();
            if (primitive.getDataSet() == null) continue;
            e.getKey().load(e.getValue());
        }
    }

    public boolean invalidBecauselayerRemoved(Layer oldLayer) {
        if (!(oldLayer instanceof OsmDataLayer)) {
            return false;
        }
        return this.layer == oldLayer;
    }

    public PrimitiveData getOrig(OsmPrimitive osm) {
        PrimitiveData o = this.cloneMap.get(osm);
        if (o != null) {
            return o;
        }
        Main.debug("unable to find osm with id: " + osm.getId() + " hashCode: " + osm.hashCode());
        for (OsmPrimitive t : this.cloneMap.keySet()) {
            PrimitiveData to = this.cloneMap.get(t);
            Main.debug("now: " + t.getId() + " hashCode: " + t.hashCode());
            Main.debug("orig: " + to.getUniqueId() + " hashCode: " + to.hashCode());
        }
        return o;
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    public abstract void fillModifiedData(Collection<OsmPrimitive> var1, Collection<OsmPrimitive> var2, Collection<OsmPrimitive> var3);

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.cloneMap.keySet();
    }

    @Override
    public Object getDescription() {
        return ((DefaultMutableTreeNode)this.description()).getUserObject();
    }

    @Deprecated
    public MutableTreeNode description() {
        return null;
    }

    private static final class CloneVisitor
    extends AbstractVisitor {
        public final Map<OsmPrimitive, PrimitiveData> orig = new LinkedHashMap<OsmPrimitive, PrimitiveData>();

        private CloneVisitor() {
        }

        public void visit(Node n) {
            this.orig.put(n, n.save());
        }

        public void visit(Way w) {
            this.orig.put(w, w.save());
        }

        public void visit(Relation e) {
            this.orig.put(e, e.save());
        }
    }
}

